;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		system.xas
;	Utility>	System routines & System info
;			style
;-----------------------------------------------------------

;#ifdef TI89
si_Y	equ	85
;#else
si_Y	equ	110
;#endif

IDCALC_92P	equ	2
IDCALC_89	equ	1
IDCALC_V200 	equ	4
IDCALC_89TI	equ	0

;-------------------------------------------------------
; Return CALC_89 or CALC_92 to know on which calc the
; prog is executed
;Input>	/
;Out>	d0.w : CALC_89, CALC_89TI, CALC_92P or CALC_V200
;-------------------------------------------------------
WhichCalc:
	clr.w	d0
	move.b	CALCULATOR,d0
	addq.w	#1,d0			;use PREOS ramcall while stay
	rts				;compatible with old pct source code



;-------------------------------------------------------
; Show system informations
;-------------------------------------------------------
SystemInfo:
	movem.l	d0-d6/a0-a6,-(a7)

	suba.w	#50,a7			;create stack frame
	move.l	a7,a2

	lea	ieMenuBar(PC),a0
	bsr	InterfaceEngine

	;--------------------------------
	; Set Calculator name in ieSoftware
	;--------------------------------
	lea	ieHdwCalc(PC),a1
	moveq.w	#15,d0
	move.l	a1,a0
\space	move.b	#' ',(a0)+
	dbra.s	d0,\space

	lea	strCalcs(PC),a0
	bsr	WhichCalc
	cmp.w	#IDCALC_89,d0
	beq.s	\calcok
	lea	12(a0),a0
	cmp.w	#IDCALC_89TI,d0
	beq.s	\calcok
	lea	12(a0),a0
	cmp.w	#IDCALC_92P,d0
	beq.s	\calcok
	lea	12(a0),a0
	cmp.w	#IDCALC_V200,d0
	beq.s	\calcok
	lea	12(a0),a0
\calcok	move.b	(a0)+,(a1)+
	bne	\calcok
	move.b	#' ',-(a1)

	;--------------------------------
	; LOOP
	;--------------------------------
\hloop	clr.w	d5			;mode
\loop	move.w	d5,d0			;mode
	lsl.w	#2,d0			;*4
	lea	S_InvRect(PC),a0
	adda.w	d0,a0
	lea	_invrect(PC),a1
	move.l	(a0),(a1)
	lea	ieSystem(PC),a0
	bsr	InterfaceEngine

	;--------------------------------
	; Test panel to draw : D5 = 
	; 0 = Hardware
	; 1 = Software
	; 2 = Memory
	;--------------------------------
	tst.w	d5
	beq	\show_hardware
	cmp.w	#1,d5
	beq	\show_software
	cmp.w	#2,d5
	beq	\show_mem
\waitkey bsr	GetKey
	cmp.w	#PAD_RIGHT,d0
	bne.s	\noright
	cmp.w	#2,d5
	beq.s	\hloop
	addq.w	#1,d5
	bra.s	\loop
\noright cmp.w	#PAD_LEFT,d0
	bne.s	\noleft
	tst.w	d5
	beq.s	\m
	subq.w	#1,d5
	bra.s	\loop
\m	moveq.w	#2,d5
	bra.s	\loop
\noleft	cmp.w	#264,d0
	bne.s	\waitkey

	adda.w	#50,a7			;delete stack frame
	moveq.w	#1,d1
	bsr	FontSet

	bsr	RedrawInterface

	movem.l	(a7)+,d0-d6/a0-a6
	rts


	;--------------------------------
	; HARDWARE PANEL
	;--------------------------------
\show_hardware:

	;--------------------------------
	; Max RAM value
	; On ti89/ti92+ : always 256kb
	; On ti92 : 128 or 256 kb
	;--------------------------------
;#ifdef TIPLUS
;#else
	lea	_maxram(PC),a0
	move.b	#'1',(a0)+
	move.b	#'2',(a0)+
	move.b	#'8',(a0)+
	btst.b	#0,$600001
	beq.s	\r128
	lea	_maxram(PC),a0
	move.b	#'2',(a0)+
	move.b	#'5',(a0)+
	move.b	#'6',(a0)+
\r128
;#endif


	;--------------------------------
	; Hardware 1 or 2 ?
	;--------------------------------
;#ifdef TIPLUS
	lea	_hw(PC),a0
	move.b	HWVERSION,d0
	add.b	#'0',d0
	move.b	d0,(a0)
\skiphw

;#endif


\getfreq lea	ieHardware(PC),a0
	bsr	InterfaceEngine

	;--------------------------------
	; Show CPU frequency
	;--------------------------------
	bsr	CPUFrequency
	movem.l	d0-d2/a0-a1,-(a7)
	divu.w	#100,d0
	swap.l	d0
	move.w	d0,-(a7)		;freq
	swap.l	d0
	move.w	d0,-(a7)		;freq
	pea	cpufreq(PC)
	move.l	a2,-(a7)		;buffer
	bsr	_sprintf
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#32,d1
	bsr	PrintSp


	;--------------------------------
	; Show batterie level
	;--------------------------------
	jsr	apilib::util_BatteriesState
	lea	gfxBatteries(PC),a0
	mulu.w	#(2*6),d0
	adda.w	d0,a0
	lea	LCD_MEM,a1
	adda.w	#(30*(YO+68)+4),a1
	moveq.w	#5,d0
\cpy	move.w	(a0)+,(a1)
	lea	30(a1),a1
	dbra.s	d0,\cpy


	bra	\waitkey


	;--------------------------------
	; SOFTWARE PANEL
	;--------------------------------
\show_software:
	lea	ieSoftware(PC),a0
	bsr	InterfaceEngine

	;--------------------------------
	; ROM version
	;--------------------------------
;#ifdef TIPLUS
	API92_ROMVERSION d0
	and.w	#$0FFF,d0

	movem.l	d0-d2/a0-a1,-(a7)
	divu.w	#$100,d0
	swap.l	d0
	move.w	d0,-(a7)		;
	swap.l	d0
	move.w	d0,-(a7)		;
	pea	romversion(PC)
	move.l	a2,-(a7)		;buffer
	bsr	_sprintf
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#30,d1
	bsr	PrintSp

	;--------------------------------
	; Show prodname
	;--------------------------------
	move.l	a2,-(a7)		;push addr
	TIOS_CALL AB_prodname
	move.l	a2,a1
	moveq.w	#10,d0
	moveq.w	#40,d1
	bsr	PrintSp

	;--------------------------------
	; Show prodid
	;--------------------------------
	TIOS_CALL AB_prodid
	move.l	a2,a1
	moveq.w	#10,d0
	moveq.w	#56,d1
	bsr	PrintSp

	;--------------------------------
	; Show serial nb
	;--------------------------------
	TIOS_CALL AB_serno
	move.l	a2,a1
	move.w	#10,d0
	moveq.w	#72,d1
	bsr	PrintSp
	addq.l	#4,a7
;#endif
	bra	\waitkey


	;--------------------------------
	; MEMORY PANEL
	;--------------------------------
\show_mem:
	;--------------------------------
	; Show free RAM 
	;--------------------------------
	move.l	#$40000,d1
;#ifdef TIPLUS
;#else
	btst.b	#0,$600001
	bne.s	\ram256
	move.l	#$20000,d1
;#endif
\ram256	jsr	apilib::GetFreeRAM
	movem.l	d0-d2/a0-a1,-(a7)
	move.l	d1,-(a7)		;total ram
	move.l	d0,-(a7)		;free ram
	pea	freeram2(PC)
	move.l	a2,-(a7)		;buffer
	bsr	_sprintf
	lea	16(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#26,d1
	bsr	PrintSp

	;--------------------------------
	; Show free archive on TI89/TI92+
	;--------------------------------
;#ifdef TIPLUS
	move.l	a7,a1
	movem.l	d0-d2/a0-a1,-(a7)
	jsr	apilib::GetFreeArchive
	move.l	d1,d3			;save used archive
	move.l	d0,-(a7)		;free archive
	pea	freeflash(PC)
	move.l	a2,-(a7)
	bsr	_sprintf
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#38,d1
	bsr	PrintSp


	movem.l	d0-d2/a0-a1,-(a7)
	move.l	d3,-(a7)		;used archive
	pea	usedflash(PC)
	move.l	a2,-(a7)
	bsr	_sprintf
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#44,d1
	bsr	PrintSp


	movem.l	d0-d2/a0-a1,-(a7)		;estack
	TIOS_ADDR top_estack,-(a7)
	pea	info_estack(PC)
	move.l	a2,-(a7)
	bsr	_sprintf
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#54,d1
	bsr	PrintSp

	movem.l	d0-d2/a0-a1,-(a7)		;free handles
	TIOS_CALL FreeHandles
	move.w	d0,-(a7)
	pea	info_freehandles(PC)
	move.l	a2,-(a7)
	bsr	_sprintf
	lea	10(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a2,a1
	move.w	#10,d0
	move.w	#60,d1
	bsr	PrintSp



;#endif


	bra	\waitkey



	


;---------------------------------------------------------
;  Return in d0 the frequency of the CPU
;
; (source code from viewlib)
;---------------------------------------------------------
CPUFrequency:
	movem.l	d1-d7/a0-a6,-(a7)

	move.w	#$400,d0
	trap	#1			;vire tout sauf int5
	move.l	d0,-(a7)		;save SR

	move.l	$74,oldint
	move.l	#newint,$40074

	moveq.l	#0,d7			;d7 = compteur

	lea	count(pc),a0
	clr.w	(a0)

\loop	tst.w	(a0)
	beq.s	\loop			;attends qu'une int5 ait eu lieu
	clr.w	(a0)

\loop2	addq.w	#1,d7
	moveq	#56,d0
	moveq	#78,d1
	moveq	#-125,d2

	mulu	d0,d1
	muls	d1,d2
	divs	d0,d2
	divu	d2,d1

	not.l	d0
	and.l	d1,d2
	eor.l	d0,d2
	or.w	d2,d1

	tst.w	(a0)
	beq.s	\loop2

	move.l	oldint(pc),$40074

	move.l	(a7)+,d0		;restore old SR
	trap	#1
	move.w	d7,d0
	and.l	#$FFFF,d0
	mulu	#75,d0
	divu	#100,d0
	and.l	#$FFFF,d0

	movem.l	(a7)+,d1-d7/a0-a6
	rts


newint:	addq.w	#1,count
	move.l	oldint(pc),-(a7)
	rts





count	dc.w	0
oldint	dc.l	0
