
;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		pstyle.xas
;	Utility>	Plugin Style
;
;-----------------------------------------------------------


PluginList:
	dc.b	%00000000,0
	dc.l	vl_MakeList
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	pl_DrawItem
	dc.l	sg1_DrawFirstItem
	dc.l	s1_PadDown
	dc.l	s1_PadUp
	dc.l	pl_SelectItem
	dc.l	s1_ClearList
	dc.l	pl_DeleteItem
	dc.l	pl_ShowComment
	dc.l	pl_KeyEnter
	dc.l	vl_EnableMenus
	dc.l	s2_DrawInterface
	dc.l	pl_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	sg1_PadLeft
	dc.l	sg1_PadRight
	dc.l	sg2_OtherKey
	dc.l	s1_BeforeDrawingList
	dc.l	RedrawList			;RedrawListArea
	dc.l	sg1_RefreshUpBar


;-------------------------------------------------------
; Create the array of all installed plugins
;-------------------------------------------------------
CreatePluginList:
	movem.l	d1-d5/a0-a2,-(a7)

	;----------------------------------
	; Create the array
	;----------------------------------
	moveq.w	#VAT_ENTRYSIZE,d1
	jsr	apilib::array_Create
	move.w	d0,d5				;save handle
	beq.s	\exit				;if =0:error


	;----------------------------------
	; Add handle of installed plugins
	;----------------------------------
	move.l	PluginTableAddr(PC),a2		;data
	move.w	(a2)+,d2			;nb items
	beq.s	\exit				;if null, exit
	subq.w	#1,d2				;for dbra

\loop	moveq.w	#VAT_ENTRYSIZE,d1
	move.w	d5,d0				;array handle
	move.l	#$D0,a0				;area of 0000
	jsr	apilib::array_AddItem		;a0 not set
	tst.w	d1
	bne.s	\exit
	move.w	(a2)+,d0			;get hdl
	bclr.l	#15,d0				;clear archived flag
	move.w	d0,VAT_ENTRYHDL(a1)
	dbra.s	d2,\loop

	;----------------------------------
	; exit subroutine
	;----------------------------------
\exit	move.w	d5,d0
	movem.l	(a7)+,d1-d5/a0-a2
	rts


;-------------------------------------------------------
; No comment function currently
;-------------------------------------------------------
pl_ShowComment:
	rts

;-------------------------------------------------------
; Initialization of Plugin style
;-------------------------------------------------------
pl_InitStyle:
	clr.w	d6
	clr.w	d7
	bsr	CreatePluginList
	tst.w	d0
	beq.s	\exit
	
	move.w	d0,ListReal_Hdl
	move.w	d0,ListBuf_Hdl

	bsr	StyleInterface
\exit	rts


;-------------------------------------------------------
; Called when key ENTER is pressed
;-------------------------------------------------------
pl_KeyEnter:
	tst.w	d6
	bne.s	\plugin
	lea	VirtualList(PC),a6		;current style
	bsr	InitStyle
	moveq.w	#4,d6
	moveq.w	#4,d7
\exit	bra	LoopRDList

\plugin	bsr	GetCurrentVATAddr
	move.w	VAT_ENTRYHDL(a0),d0

	movem.l	d0-d7/a0-a6,-(a7)
	move.w	d0,-(a7)
	jsr	kernel::exec
	addq.l	#2,a7
	movem.l	(a7)+,d0-d7/a0-a6
	bsr	RedrawKeepingStatusBar

;	bsr	ExecFileAndRedraw

	bra.s	\exit


;-------------------------------------------------------
; Select item
;-------------------------------------------------------
pl_SelectItem:
	movem.l	d0-d1/a0,-(a7)

	bsr	ItemScrPos
	moveq.w #7,d1           ; 8 lines

\loopy
;#ifdef TI89
	moveq.w	#17,d0
;#else
	moveq.w	#27,d0
;#endif
\line	not.b   (a0)+
	dbra.s	d0,\line
;#ifdef TI89
	lea	12(a0),a0
;#else
	addq.l	#2,a0
;#endif
	dbra.s  d1,\loopy

	movem.l	(a7)+,d0-d1/a0
	rts


;-------------------------------------------------------
; Delete Item
;-------------------------------------------------------
pl_DeleteItem:
	movem.l	d0-d3/a0,-(a7)
	bsr	ItemScrPos
	subq.w	#1,a0

	moveq.w #7,d3           ;delete 8 lines
\line	move.b	#%10100000,(a0)
;#ifdef TI89
	moveq.w	#17,d1
;#else
	moveq.w #27,d1          ;and 8 cols
;#endif
	move.b	#%00000101,2(a0,d1.w)
\row	clr.b   1(a0,d1.w)
\no     dbra.s  d1,\row
	lea     30(a0),a0       ;adda.w #30,a0
	dbra.s  d3,\line

	movem.l	(a7)+,d0-d3/a0	
	rts


;-------------------------------------------------------
; Draw item in the list
;-------------------------------------------------------
pl_DrawItem:
	movem.l	d0-d1,-(a7)			;save X,Y

	;----------------------------------
	; Search plugin according to its
	; handle
	;----------------------------------
	clr.w	d1
	bsr	FontSet
	move.w	VAT_ENTRYHDL(a2),d0		;handle
	bsr	DEREFd0a0			;get addr

	movem.l	(a7)+,d0-d1			;restore X,Y

	;----------------------------------
	; Look for comment in the plugin
	;----------------------------------
	move.w  COMMENT_OFFSET+2(a0),d2		;offset of info
	beq.s   \exit				;if zero exit
;#ifdef TIPLUS
	lea     2(a0,d2.w),a1
;#else
	lea     0(a0,d2.w),a1
;#endif
	addq.w	#1,d1

	;----------------------------------
	; Draw it
	;----------------------------------
	bsr	PrintSp
\exit	moveq.w	#1,d1
	bsr	FontSet
	rts



