;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		error.xas
;	Utility>	Error Management
;
;-----------------------------------------------------------

;------------------------------------------------------
; EC_OUTOFMEMORY 
; EC_
;------------------------------------------------------

;-----------------------------------------------------
;Input>	d1.w : error code
;-----------------------------------------------------
apilib@0032
_ErrorDialogBox:
	movem.l	a0/a2,-(a7)

	move.l	a0,a2			;save a0
	lea	ErrWin(PC),a0
	bsr	_InterfaceEngine

\errmsg	cmp.w	#EC_OUTOFMEMORY,d1
	beq.s	\outofmem
	cmp.w	#EC_INVALIDINDEX,d1
	beq.s	\invalidid
	cmp.w	#EC_VARARCHIVED,d1
	beq.s	\vararchived
	cmp.w	#EC_VARINUSE,d1
	beq.s	\varinuse
	cmp.w	#EC_FILEEXIST,d1
	beq.s	\fileexist
	cmp.w	#EC_FOLDEREXIST,d1
	beq.s	\folderexist
	cmp.w	#EC_ERRORMESSAGE,d1
	beq.s	\errormessage
	
	lea 	err1(PC),a0		;unknown error

\showmsg bsr	_InterfaceEngine
	bsr	_WaitKey

	movem.l	(a7)+,a0/a2
	rts

\outofmem lea	err2(PC),a0
	bra.s	\showmsg

\invalidid
	lea	err3(PC),a0
	bra.s	\showmsg

\errormessage	move.l	a2,a0
	bra.s	\showmsg

\vararchived	lea	err6(PC),a0
		bra.s	\varerror

\fileexist lea	err4(PC),a0
	bra.s	\varerror

\folderexist lea err10(PC),a0
	bra.s	\varerror

\varinuse	lea	err5(PC),a0

\varerror
	move.l	a0,-(a7)
	suba.w	#40,a7			;Create stack frame
	move.l	a7,a0
	moveq.w	#25,d1			;max length
	jsr	_nf_GetVatName		;d0,d2 are set
	tst.w	d1
	bne.s	\err2			;should not make an infinite loop
	move.l	a0,sErrVar
	lea	err56(PC),a0
	bsr	_InterfaceEngine
	adda.w	#40,a7
	move.l	(a7)+,a0
	bra.s	\showmsg

\err2	adda.w	#40+4,a7
	bra	\errmsg

ErrWin	dc.b	IE_WIN2,40+XO,40+YO,199+XO,80+YO,"Error",0
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,45+XO,53+YO,"Error :",0
	dc.b	IE_END

err1	dc.b	IE_STRING,50+XO,65+YO,"Unknown Error",0
	dc.b	IE_END

err2	dc.b	IE_STRING,50+XO,65+YO,"Out of memory",0
	dc.b	IE_END

err3	dc.b	IE_STRING,50+XO,65+YO,"Index out of range",0
	dc.b	IE_END

err56	dc.b	IE_STRING,90+XO,53+YO,"the file",0
	dc.b	IE_STRING,45+XO,61+YO,">",0
	dc.b	IE_STRINGADDR,51+XO,61+YO
sErrVar	dc.l	0
	dc.b	IE_END

err4	dc.b	IE_STRING,45+XO,70+YO,"already exists.",0
	dc.b	IE_END

err5	dc.b	IE_STRING,45+XO,70+YO,"is currently in use.",0
	dc.b	IE_END

err6	dc.b	IE_STRING,45+XO,70+YO,"is archived.",0
	dc.b	IE_END

err10	dc.b	IE_STRING,45+XO,70+YO,"already exists.",0
	dc.b	IE_STRING,90+XO,53+YO,"the folder",0
	dc.b	IE_END


	ds.w	0

