;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		anticrash.mdl
;	Utility>	Anti-Crash Handler
;			ported from DoorsOS 0.98 source code
;-----------------------------------------------------------

NB_SAVED_VECTORS equ	16


;#ifdef NSTUB

saved_vectors:	dc.l	$00000C,0		;Address Error
		dc.l	$000010,0		;Illegal Instruction
		dc.l	$000014,0		;Divide by zero
		dc.l	$000018,0		;CHK
		dc.l	$00001c,0		;TRAPV
		dc.l	$000020,0		;Privilege Violation
		dc.l	$000024,0		;Trace
		dc.l	$00002C,0		;Line 1011
		dc.l	$000060,0		;Spurious
		dc.l	$00007C,0		;Memory Violation
		dc.l	$80+4*5,0		;Trap 5
		dc.l	$80+4*6,0		;Trap 6
		dc.l	$80+4*7,0		;Trap 7
		dc.l	$80+4*13,0		;Trap 13
		dc.l	$80+4*14,0		;Trap 14
		dc.l	$80+4*15,0		;Trap 15 : ER_Throw
		dc.l	$64,0			;Auto-Int 1
		dc.l	$64+4,0			;Auto-Int 2
		dc.l	$64+4*2,0		;Auto-Int 3
		dc.l	$64+4*3,0		;Auto-Int 4
		dc.l	$64+4*4,0		;Auto-Int 5
		dc.l	$64+4*5,0		;Auto-Int 6
		dc.l	$64+4*6,0		;Auto-Int 7
	
error_string	dc.l	0

adrerr	dc.b	"Address Error",0
illerr	dc.b	"Illegal Instruction",0
zero	dc.b	"Divide By Zero",0
chki	dc.b	"CHK Instruction",0
trapvi	dc.b	"TRAPV Instruction",0
trace	dc.b	"Trace",0
privi	dc.b	"Privilege Violation",0
line11	dc.b	"Line 1111 Emulator",0
spur	dc.b	"Spurious Interrupt",0
mem	dc.b	"Memory Violation",0
tr5	dc.b	"Trap 5",0
tr6	dc.b	"Trap 6",0
tr7	dc.b	"Trap 7",0
tr13	dc.b	"Trap 13",0
tr14	dc.b	"Trap 14",0
tr15	dc.b	"Trap 15",0

	ds.w	0

;-------------------------------------------------------------------
; Install Anti-Crash Handler
;-------------------------------------------------------------------
ac_InstallHandler:
	;-----------------------------------------
	; Disable Mem protection & Interrupt
	;-----------------------------------------
	bclr.b	#2,$600001	;Disable protection
	move.w	#$0700,d0
	trap	#1
	move.l	d0,-(a7)

	;-----------------------------------------
	; Save vectors & set new vectors
	;-----------------------------------------
	lea	saved_vectors(PC),a0
	lea	ac_Handlers(PC),a2
	moveq.w	#NB_SAVED_VECTORS-1,d0
\loop	move.l	(a0)+,a1
	;adda.l	#$400000,a1
	move.l	(a1),(a0)+			;save previous handler
	move.l	a2,(a1)
	adda.w	#12,a2
	dbra.s	d0,\loop

	;-----------------------------------------
	; Enable Mem protection & interrupt
	;-----------------------------------------
	bset.b	#2,$600001	;Disable protection
	move.l	(a7)+,d0
	trap	#1
	rts


;-------------------------------------------------------------------
; Uninstall Anti-Crash Handler
;-------------------------------------------------------------------
ac_UninstallHandler:
	;-----------------------------------------
	; Disable Mem protection & Interrupt
	;-----------------------------------------
	bclr.b	#2,$600001	;Disable protection
	move.w	#$0700,d0
	trap	#1
	move.l	d0,-(a7)

	;-----------------------------------------
	; Restore saved vectors
	;-----------------------------------------
	lea	saved_vectors(PC),a0
	moveq.w	#NB_SAVED_VECTORS-1,d0
\loop	move.l	(a0)+,a1
	;adda.l	#$400000,a1
	move.l	(a0)+,(a1)+
	dbra.s	d0,\loop


	;-----------------------------------------
	; Enable Mem protection & interrupt
	;-----------------------------------------
	bset.b	#2,$600001	;Disable protection
	move.l	(a7)+,d0
	trap	#1


	rts


;-------------------------------------------------------------------
; Anti-Crash Handler
;-------------------------------------------------------------------
ac_Handlers:
ADRERROR
	move.w	#$2700,SR
	lea	adrerr(pc),a0
	bra.w	crash
ILLEGALI
	move.w	#$2700,SR
	lea	illerr(pc),a0
	bra.w	crash
zeroz
	move.w	#$2700,SR
	lea	zero(pc),a0
	bra.w	crash
chkiz
	move.w	#$2700,SR
	lea	chki(pc),a0
	bra.w	crash
trapviz
	move.w	#$2700,SR
	lea	trapvi(pc),a0
	bra.w	crash
priviz
	move.w	#$2700,SR
	lea	privi(pc),a0
	bra.w	crash
tracez
	move.w	#$2700,SR
	lea	trace(pc),a0
	bra.w	crash
line11z
	move.w	#$2700,SR
	lea	line11(pc),a0
	bra.w	crash
spurz
	move.w	#$2700,SR
	lea	spur(pc),a0
	bra.w	crash
memviol
	move.w	#$2700,SR
	lea	mem(pc),a0
	bra.w	crash
tr5z
	move.w	#$2700,SR
	lea	tr5(pc),a0
	bra.w	crash
tr6z
	move.w	#$2700,SR
	lea	tr6(pc),a0
	bra.w	crash
tr7z
	move.w	#$2700,SR
	lea	tr7(pc),a0
	bra.w	crash
tr13z
	move.w	#$2700,SR
	lea	tr13(pc),a0
	bra.w	crash
tr14z
	move.w	#$2700,SR
	lea	tr14(pc),a0
	bra.w	crash
tr15z
	move.w	#$2700,SR
	lea	tr15(pc),a0
	
crash:	move.l	a0,error_string
	move.w	#$700,sr	; user mode, ints off
	dc.w	$A006		; trigger line1010 exception with value 0x6 : Throw Error : "Assembly crash"


;#endif

