;---------------------------------------------------
;                       Xetrion 
;               assembly source code
;
; (c) Copyright Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------
; xetfilop.asm : Files Operations functions
;---------------------------------------------------


;---------------------------------------------------
; Recursive Function called to calculate the
; size of a folder
;Input> d0.w : folder handle
;       d3.w : 0 if allow recursiv call
;Out>	d2.l : Size of the folder
;---------------------------------------------------
CalcSize:
	move.l	d1,-(a7)
	move.w	d3,d1
	jsr	apilib::nf_GetFolderSize
	move.l	(a7)+,d1	
	rts




;modify only a1
RealCurrentVat:
	movem.l	d0-d2/a0,-(a7)
	jsr	RealFileIndex
	movem.l	(a7)+,d0-d2/a0
	rts

;---------------------------------------------------
; return the index of the selected file in the
; VAT
;out>   d0.w : real handle of folder
;       d2.w : index of item in real VAT
;       d1.w : hdl of item if succeed. 0 if error
;       a0.l : addr of item addr if normal folder
;       a1.l : addr of real VAT addr
;
;if d6.w=0 d0.w =real hdl folder only is set
;--------------------------------------------------- 
RealFileIndex:
	tst.w	d6
	bne.s	\skip
	move.w  ListReal_Hdl(PC),d0	;hdl of real VAT
	bra.s	\exit

\skip	bsr     GetCurrentVATAddr       ;set a0 = name of current file

	move.w  ListReal_Hdl(PC),d0	;hdl of real VAT
	move.w	VAT_ENTRYHDL(a0),d1	;item hdl
        btst.b  #7,ENTRYFLG+1(a0)       ;if folder bit 
        beq.s   \nonested               ;
        API92_FOLDHDL d0		;set d0=folder list (normal/nested)

\nonested jsr	apilib::vat_FindHdl
	subq.w	#1,d2			;0-based index
\exit   rts

;---------------------------------------------------
; Change the attrib of the selected file
;input> d6.w : pos
;       d2.w : bit to change
;       d0.w :  0 if error
;               else if succeed
;chg a0,a1
;---------------------------------------------------
ChangeAttr:
	clr.w   d0              ;default error value
	tst.w   d6              ;if first item exit
	beq.s   \nochg

        move.l  d2,-(a7)
	bsr.s   RealFileIndex   ;
        move.l  (a7)+,d2
        move.w  d1,d0           ;if item not found (ret value=0 in d0)
	beq.s   \nochg          ;exit

	cmp.w   #SLCT_BIT,d2    ;bit to change=slct ?
	bne.s   \skip
	btst.b  #7,ENTRYFLG+1(a1)       ;and if folder
	bne.s   \nochg
\skip
		    
;#ifdef TIPLUS
       cmp.w    #LOCK_BIT,d2
       bne.s    \skip2
       btst.b   #ARCH_BIT,ENTRYFLG(a1)
       bne.s    \nochg
\skip2
;#endif

	bchg.b  d2,ENTRYFLG+1(a1) ;else chg attrib
	moveq.w #1,d0
\nochg  rts



;----------------------------------------------------
;Select a file
;----------------------------------------------------
SelectFile:
	btst.b	#0,S_MODE(a6)			;Check if true VAT
	beq.s	\exit

	tst.w	d6
	bne.s	\nofirst

	;-----------------------------------
	; If first item selected
	;-----------------------------------
	bsr	GetListBufAddr
	move.w	d1,d0				;Handle
	beq.s	\exit
	bsr	vat_CountSelection		;
	cmp.w	(a0),d0
	bne	SelectAll
	bra	_DeselectAll

	;-----------------------------------
	; Else
	;-----------------------------------
\nofirst moveq.w #SLCT_BIT,d2
	bsr     ChangeAttr
	tst.w   d0
	beq.s   \exit

	bsr     DeleteItem                      ;delete previous item
	bsr	GetItemXY			;Get X/Y
	move.l	a1,a2
	bsr	DrawItem
	bsr	SelectItem
	bsr	MakeList
\exit   bra     Loop

;---------------------------------------------------
;Deselect all items in the current list
;---------------------------------------------------
DeSelectAll:
	btst.b	#0,S_MODE(a6)
	bne.s	_deslct
	rts

_deslct: bsr     GetRealListAddr		;get addr of real list
	
	move.w  (a2)+,d0			;get nb of files
	beq.s   \exit				;if null, exit
	subq.w  #1,d0				;-1 for loop
\loop	bclr.b  #SLCT_BIT,ENTRYFLG+1(a2)	;clear select bit flag
	lea     VATENTRY_SIZE(a2),a2		;next VAT entry
	dbra.s  d0,\loop
\exit	rts

_DeselectAll:
	bsr	DeSelectAll
	bra	LoopRDList

DeselectLink:
	bsr	_deslct
	bra	LoopRDList

;----------------------------------------------------
; Select All items
;----------------------------------------------------
SelectAll:
	move.l  d6,-(a7)                ;save d6

	bsr     _deslct			;first deselect all

	bsr     GetListBufAddr
	move.w  (a0)+,d3                ;d3=nb items
	beq.s   \exit                   ;if 0 directly exit

	moveq.w #1,d6
	subq.w  #1,d3                   ;nbitems-1 for dbra
\loop   moveq.w #SLCT_BIT,d2            ;select bit number
	bsr     ChangeAttr
	addq.w  #1,d6                   ;increase selected item
	dbra.s  d3,\loop

\exit   move.l  (a7)+,d6
	bra     LoopRDList

;---------------------------------------------
;print the d1 error number
;-------------------------------------------
MsgError:
	move.w  d1,-(a7)
	TIOS_CALL ERD_dialog
	addq.l  #2,a7
	rts


