;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		strings.xas
;	Utility>	Definition of strings
;
;-----------------------------------------------------------



;=========================================================
; 1. MENU STRINGS
;=========================================================

;---------------------------------------------------------
; File Menu
;---------------------------------------------------------
mnuFileData:
	dc.b	MNU_FILE_COPY
	dc.b	MNU_FILE_MOVE
	dc.b	MNU_FILE_RENAME
	dc.b	MNU_FILE_DELETE
	dc.b	MNU_FILE_NEWF
;#ifdef TIPLUS
	dc.b	MNU_BAR
	dc.b	MNU_FILE_ARCH
	dc.b	MNU_FILE_UNARCH
;#endif
	dc.b	MNU_BAR
	dc.b	MNU_FILE_EXIT

;---------------------------------------------------------
; Secure Menu
;---------------------------------------------------------
mnuSecureData:
	dc.b	MNU_SECURE_LOCK
	dc.b	MNU_SECURE_HIDE
	dc.b	MNU_BAR
	dc.b	MNU_SECURE_PROTECT
	dc.b	MNU_SECURE_BOLT

;---------------------------------------------------------
; Tools Menu
;---------------------------------------------------------
mnuToolsData:
	dc.b	MNU_TOOLS_SELECT
	dc.b	MNU_TOOLS_SELECTALL
	dc.b	MNU_TOOLS_DESELECT
	dc.b	MNU_BAR
	dc.b	MNU_TOOLS_OPTIONS
	dc.b	MNU_TOOLS_MEMFILTERS
	dc.b	MNU_TOOLS_ABOUT


	ds.w	0

;=========================================================
; 2. VAR FUNCTIONS STRINGS
;=========================================================

winInfo	dc.b	WIN_ENTERESC

winRename:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,30+YO,199+XO,84+YO,WIN_RENAME_TITLE
	dc.b	IE_NOP,IE_STRING,45+XO,44+YO,WIN_RENAME_S1
	dc.b	IE_STRINGADDR,45+XO,52+YO
winRenameVar dc.l	0
	dc.b	IE_SETFONT,0
	dc.b	IE_NOP,IE_STRINGADDR,50+XO,76+YO
	dc.l	winInfo
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,45+XO,64+YO,WIN_RENAME_S2
	dc.b	IE_END


winNewFolder:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,30+YO,199+XO,84+YO,WIN_NF_TITLE
	dc.b	IE_STRING,45+XO,44+YO,WIN_NF_S1
	dc.b	IE_STRINGADDR,45+XO,52+YO
winFolderName dc.l 0
	dc.b	IE_SETFONT,0
	dc.b	IE_NOP,IE_STRINGADDR,50+XO,76+YO
	dc.l	winInfo
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,45+XO,64+YO,WIN_NF_S2
	dc.b	IE_END

winDelete:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,38+YO,199+XO,82+YO,WIN_DELETE_TITLE
	dc.b	IE_NOP,IE_STRING,45+XO,53+YO,WIN_DELETE_S1
	dc.b	IE_NOP,IE_STRINGADDR,45+XO,62+YO
winDeleteName dc.l 0
	dc.b	IE_SETFONT,0
	dc.b	IE_NOP,IE_STRINGADDR,50+XO,74+YO
	dc.l	winInfo
	dc.b	IE_SETFONT,1
	dc.b	IE_END

	ds.w	0

winCopy:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,30+YO,199+XO,90+YO,WIN_COPY_TITLE
	dc.b	IE_STRING,45+XO,43+YO,WIN_COPY_S1
	dc.b	IE_END

winCopyMove:
	dc.b	IE_STRING,45+XO,62+YO,WIN_COPY_S2
	dc.b	IE_NOP,IE_STRINGADDR,45+XO,51+YO
winCopyName dc.l 0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,46+XO,82+YO,18,WIN_COPY_S3
	dc.b	IE_SETFONT,1
	dc.b	IE_END

winMove:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,30+YO,199+XO,90+YO,WIN_MOVE_TITLE
	dc.b	IE_STRING,45+XO,43+YO,WIN_MOVE_S1
	dc.b	IE_END


winExecB: dc.b	IE_ANIMEDWIN2,ANIMTIMER,45+XO,35+YO,194+XO,88+YO,WIN_RUNB_TITLE
	dc.b	IE_STRING,52+XO,50+YO,WIN_RUNB_S1
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,62+XO,80+YO,WIN_RUNB_S2
	dc.b	IE_SETFONT,1
	dc.b	IE_END

winReplaceVar:
	dc.b    IE_ANIMEDWIN2,ANIMTIMER,40+XO,30+YO,199+XO,90+YO,WIN_REPLACE_TITLE
	dc.b	IE_SETFONT,0
	dc.b    IE_STRING
;#ifdef FRENCH
	dc.b	46+XO
;#else
	dc.b	50+XO
;#endif
	dc.b	81+YO,WIN_REPLACE_S1
	dc.b    IE_SETFONT,1
	dc.b    IE_STRING,45+XO,43+YO,WIN_REPLACE_S2
	dc.b    IE_STRING,45+XO,60+YO,WIN_REPLACE_S3
	dc.b    IE_END

;=========================================================
; 3. GENERAL STRINGS
;=========================================================
s_SFile	dc.b	STR_SLCTFILES
freeram	dc.b	STR_FREERAM
backtxt	dc.b	17,LSTY,"[...]",0
vlisttxt dc.b	17,LSTY,STR_HOME

;#ifdef TI89
titxt	dc.b	17,LSTY,"TI89",0
;#else
titxt	dc.b	17,LSTY,"TI92",0
;#endif

folderfile dc.b	"%s\%s",0


winLoadPlugins:	dc.b	IE_WIN2,50+XO,45+YO,189+XO,75+YO,WIN_LOADPLG_TITLE
		dc.b	IE_SETFONT,0
		dc.b	IE_STRING,54+XO,66+YO,WIN_LOADPLG_S2
		dc.b	IE_SETFONT,1
		dc.b	IE_STRING,54+XO,58+YO,WIN_LOADPLG_S1
		dc.b	IE_END

ieNotAvailable:	dc.b	IE_SETFONT,0
		dc.b	IE_STRING,90,30,"Function Currently",0
		dc.b	IE_STRING,90,38,"not available",0
		dc.b	IE_SETFONT,1
		dc.b	IE_END

ieZipPlugin	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,40+YO,189+XO,80+YO,STR_NOZIP
		dc.b	IE_SETFONT,0
		dc.b	IE_STRING,56+XO,55+YO,STR_NOZIP1
		dc.b	IE_STRING,56+XO,62+YO,STR_NOZIP2
		dc.b	IE_STRING,56+XO,71+YO,STR_NOZIP3
		dc.b	IE_SETFONT,1
		dc.b	IE_WAITKEY
		dc.b	IE_END


s_noplugin	dc.b	STR_NOPLUGIN

;=========================================================
; 4. ABOUT/LICENSE WINDOWS
;=========================================================
winAbout:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,55+XO,35+YO,184+XO,85+YO,MNU_TOOLS_ABOUT
	dc.b	IE_STRING,98+XO,50+YO,"PCTOOLS ",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,75+XO,59+YO,"Version: 0.97b - Ibrahim",0
	dc.b	IE_STRING,60+XO,69+YO,"(c) NeXO Sofware, Benoit SCHERRER",0
	dc.b	IE_STRING,60+XO,76+YO,"benoitscherrer@gmail.com",0
	dc.b	IE_SETFONT,1
	dc.b	IE_WAITKEY
	dc.b	IE_END

winLicense:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,45+XO,30+YO,194+XO,90+YO,"License",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,50+XO,42+YO,WIN_ABOUT_S1
	dc.b	IE_STRING,50+XO,48+YO,WIN_ABOUT_S2
	dc.b	IE_STRING,50+XO,54+YO,WIN_ABOUT_S3
	dc.b	IE_STRING,60+XO,62+YO,"Benoit SCHERRER",0
	dc.b	IE_STRING,60+XO,68+YO,"3 rue de l arsenal",0
	dc.b	IE_STRING,60+XO,74+YO,"76310 Ste Adresse / FRANCE",0
	dc.b	IE_STRING,50+XO,82+YO,WIN_ABOUT_S4
	dc.b	IE_WAITKEY
	dc.b	IE_SETFONT,1
	dc.b	IE_END


	ds.w	0


;=========================================================
; 5. FILTER WINDOW
;=========================================================
winFilter:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,60+XO,30+YO,179+XO,89+YO,WIN_FILTER_TITLE
	dc.b	IE_SETFONT,1
	dc.b	IE_END


FilterMenuData:
	dc.b	FILTER_EXTFILT
	dc.b	FILTER_ADVFILT
	dc.b	MNU_BAR
	dc.b	FILTER_SAVE
	dc.b	FILTER_DELETE
	
AdvFilterData:
	dc.b	ADVFILTER_HIDDEN
	dc.b	ADVFILTER_LOCKED
	dc.b	ADVFILTER_TMP
	dc.b	ADVFILTER_ZIPPED
	dc.b	ADVFILTER_RELOC
;#ifdef TIPLUS
	dc.b	"RAM",0
	dc.b	"Archive",0
;#endif

ieSaveFilter
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,44+YO,189+XO,84+YO,WIN_SAVEFILT_TITLE
	dc.b	IE_STRING,60+XO,59+YO,WIN_SAVEFILT_S1
	dc.b	IE_SETFONT,1
	dc.b	IE_END


NoSavedFilterData:
	dc.b	FILTER_NOSAVED

	ds.w	0

;=========================================================
; 6. SYSTEM INFO STRINGS
;=========================================================
ieSystInfo:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,30+YO,200+XO,102+YO,"System Info",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,50+XO,69+YO,INFO_BATT
;#ifdef TIPLUS
	dc.b	IE_STRING,50+XO,85+YO,INFO_PRODUCTID
	dc.b	IE_STRING,50+XO,92+YO,INFO_SERIALNB
;#endif
	dc.b	IE_END

ieErrorCatcher
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,40+YO,189+XO,80+YO,WIN_ERROR_TITLE
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,55+XO,55+YO,WIN_ERROR_MEM
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,55+XO,66+YO,WIN_ERROR_S1
	dc.b	IE_WAITKEY
	dc.b	IE_END

	ds.w	0

ieErrorCatcher2
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,40+YO,189+XO,80+YO,WIN_ERROR_TITLE
	dc.b	IE_SETFONT,1
	dc.b	IE_NOP,IE_STRINGADDR,55+XO,60+YO
ieEC_str dc.l	0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,55+XO,53+YO,WIN_ERROR_S2
	dc.b	IE_STRING,55+XO,70+YO,WIN_ERROR_S1
	dc.b	IE_WAITKEY
	dc.b	IE_END

ieEC_SUnknown	dc.b	EC_SUNKNOWN
ieEC_SAlign	dc.b	EC_SALIGN
ieEC_Sd6	dc.b	EC_SD6
ieEC_d6toobig	dc.b	EC_SD6TOOBIG


freeram2		dc.b	INFO_FREERAM
cpufreq			dc.b	INFO_CPUFREQ
info_estack		dc.b	INFO_TOPESTACK
info_freehandles	dc.b	INFO_FREEHANDLE


;#ifdef TIPLUS
freeflash 		dc.b	INFO_FREEARCHIVE
usedflash 		dc.b	INFO_USEDARCHIVE

romversion dc.b	"ROM : %d.%02d",0
;#endif

	ds.w	0

ieMenuBar:
	dc.b	IE_SETFONT,0
	dc.b	IE_SOLIDRECT,10,1,225+LW,10
	dc.b	IE_STRING,11,4,INFO_MENU
	dc.b	IE_INVERTAREA,11,2,214+LW,8
	dc.b	IE_END

ieSystem:
	dc.b	IE_SOLIDRECT,2,21,237+LW,119+LH
	dc.b	IE_SOLIDRECT,2,13,237+LW,21
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,10,15,INFO_HARDWARE
	dc.b	IE_STRING,55,15,INFO_SOFTWARE
	dc.b	IE_STRING,100,15,INFO_MEMORY
;f ENGLISH
	dc.b	IE_NOP
;if
	dc.b	IE_INVERTAREA
_invrect dc.b	0,0,10,10
	dc.b	IE_STRING,5,si_Y,INFO_INFO
	dc.b	IE_END

	ds.w	0
S_InvRect: dc.b 8,14,39,7
	dc.b	53,14,37,7
	dc.b	98,14,33,7

ieHardware:
	dc.b	IE_STRING,10,24,INFO_CALCHARD
_hw	dc.b	"1",0
	dc.b	IE_STRING,10,45,INFO_INSTRAM
_maxram	dc.b	"256 ",INFO_KBYTES
	dc.b	IE_STRING,10,55,INFO_BATT

	dc.b	IE_END

ieSoftware:
;#ifdef TIPLUS
	dc.b	IE_STRING,10,24,INFO_CALC," : "
ieHdwCalc:
	dc.b	"????????????????",0
;#else
	dc.b	IE_STRING,10,24,INFO_CALC," : TI-92",0
	dc.b	IE_STRING,10,34,"ROM : ???",0
;#endif
;#ifdef TIPLUS
	dc.b	IE_STRING,10,50,INFO_PRODUCTID
	dc.b	IE_STRING,10,66,INFO_SERIALNB
;#endif
	dc.b	IE_END

strCalcs dc.b	"TI-89      ",0
	dc.b	"TI-89 Ti   ",0
	dc.b	"TI-92 PLUS ",0
	dc.b	"V200       ",0
	dc.b	"Unknown    ",0


	ds.w	0



;=========================================================
; 7. INTERFACE
;=========================================================
;#ifdef TI89
;#ifdef FRENCH
IM_FILE		equ 9
;#else
;#ifdef SPANISH
IM_FILE		equ 8
;#else
IM_FILE		equ 13
;#endif
;#endif
IM_SECURE	equ 45
IM_TOOLS	equ 85
IM_PLUGINS	equ 120
;#else
IM_FILE		equ 13
IM_SECURE	equ 70
IM_TOOLS	equ 130
IM_PLUGINS	equ 185
;#endif

ieListRect:	dc.b	IE_SOLIDRECT,0,11,239+LW,121+LH
		dc.b	IE_END

ieInterface:
	dc.b    IE_SETFONT,0
	dc.b    IE_STRING,IM_FILE,4,MNU_FILE
	dc.b	IE_STRING,IM_SECURE,4,MNU_SECURE
	dc.b    IE_STRING,IM_TOOLS,4,MNU_TOOLS
	dc.b    IE_STRING,IM_PLUGINS,4,MNU_PLUGINS
	dc.b    IE_SETFONT,1
	dc.b	IE_INVERTAREA,0,0,WLCD,11
	dc.b	IE_SOLIDRECT,0,11,239+LW,121+LH

	dc.b    IE_END


;#ifdef TI89
CYO              equ     0
CXO              equ     0
;#else
CYO              equ     -10
CXO              equ     -40
;#endif

ieInvalidCalc:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+CXO,40+CYO,189+CXO,80+CYO,WIN_INVALIDCALC
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,55+CXO,55+CYO,STR_CALC1
	dc.b	IE_STRING,55+CXO,62+CYO,STR_CALC2
	dc.b	IE_STRING,55+CXO,71+CYO,STR_CALC3
	dc.b	IE_WAITKEY
	dc.b	IE_END


;=========================================================
; 8. PASSWORD WINDOWS
;=========================================================
	ds.w	0

winPassword:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,35+YO,189+XO,75+YO,WIN_PSW_TITLE
	dc.b	IE_NOP,IE_STRINGADDR,60+XO,48+YO
winPassStr dc.l	0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,61+XO,67+YO,WIN_PSW_S1
	dc.b	IE_SETFONT,1
	dc.b	IE_END

PassStr1 dc.b	WIN_PSW_S2
PassStr2 dc.b	WIN_PSW_S3
PassStr3 dc.b	WIN_PSW_S4
PassStr4 dc.b	WIN_PSW_S5


winPassResult:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,60+XO,45+YO,179+XO,73+YO,WIN_PSW_TITLE
;#ifdef ENGLISH
	dc.b	IE_NOP
;#endif
	dc.b	IE_STRINGADDR,70+XO,58+YO
winPRStr: dc.l	0
	dc.b	IE_WAITKEY
	dc.b	IE_END


winNoPass:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,35+YO,189+XO,75+YO,WIN_PSW_TITLE
	dc.b	IE_STRING,58+XO,51+YO,WIN_PSW_S6
	dc.b	IE_STRING,58+XO,59+YO,WIN_PSW_S7
	dc.b	IE_WAITKEY
	dc.b	IE_END


PassStr5 dc.b	WIN_PSW_S8
PassStr6 dc.b	WIN_PSW_S9

	ds.w	0


;=========================================================
; 10. HELP STRINGS
;=========================================================
strNul		dc.b	0
strTI		dc.b	STR_HOME_ROOT
strSyst		dc.b	STR_HOME_SYST
strLink		dc.b	STR_HOME_LINK
strPlugins	dc.b	STR_HOME_PLUGINS

strRunLib	dc.b	STR_RUN_LIB

	ds.w	0

;=========================================================
; 11. OPTION WINDOW
;=========================================================
ieOptionWin:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,65+XO,32+YO,174+XO,91+YO,WIN_OPTION_TITLE
	dc.b	IE_END

OptionData:
	dc.b	WIN_OPTION_M1
	dc.b	WIN_OPTION_M2
	dc.b	WIN_OPTION_M3
	dc.b	WIN_OPTION_M4
	dc.b	WIN_OPTION_M5
	dc.b	WIN_OPTION_M6

InterfaceData:
	dc.b	WIN_OPTION_I1
	dc.b	WIN_OPTION_I2



mnuShortByData:
	dc.b	WIN_OPTION_SBYNAME
	dc.b	WIN_OPTION_SBYEXT
	dc.b	WIN_OPTION_SBYSIZEUP
	dc.b	WIN_OPTION_SBYSIZEDOWN

mnuStyleData:
	dc.b	WIN_OPTION_STYLE1
	dc.b	WIN_OPTION_STYLE2
	dc.b	WIN_OPTION_STYLE3

	ds.w	0

;=========================================================
; 12. ASSOCIATE WINDOW
;=========================================================
win_Associate:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,32+YO,189+XO,90+YO,WIN_ASSO_TITLE
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,60+XO,82+YO,WIN_ASSO_S1
	dc.b	IE_SETFONT,1
	dc.b	IE_END

win_AddAsso
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,54+XO,43+YO,185+XO,86+YO,WIN_ASSO_TITLE2
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,60+XO,55+YO,WIN_ASSO_S3
	dc.b	IE_STRING,60+XO,63+YO,WIN_ASSO_S4
	dc.b	IE_SETFONT,0
	dc.b	IE_END

win_DelAsso
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,60+XO,50+YO,179+XO,80+YO,WIN_ASSO_TITLE3
	dc.b	IE_STRING,70+XO,62+YO,WIN_ASSO_S5
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,82+XO,72+YO,WIN_ASSO_S9
	dc.b	IE_SETFONT,1
	dc.b	IE_END

asso_SignCB dc.b 0,0,60+XO,72+YO,WIN_ASSO_S6
asso_ParamCB dc.b 0,0,60+XO,78+YO,WIN_ASSO_S7

asso_empty dc.b	WIN_ASSO_S8


;=========================================================
; 13. LINK routines
;=========================================================

ieLinkErrorCatcher:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,40+YO,189+XO,80+YO,LINK_ERROR
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,60+XO,53+YO,LINK_ERROR
	dc.b	IE_SOLIDRECT,60+XO,61+YO,170+XO,62+YO
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,60+XO,65+YO,LINK_ERROR_S1
	dc.b	IE_STRING,60+XO,71+YO,LINK_ERROR_S2
	dc.b	IE_WAITKEY
	dc.b	IE_SETFONT,1
	dc.b	IE_END
	ds.w	0

ieReceiveFiles:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,40+XO,35+YO,199+XO,90+YO,LINK_RECEIVEFILE
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,46+XO,82+YO,18,WIN_COPY_S3
	dc.b	IE_END

	ds.w	0

ieLinkDest:
	dc.b	IE_SETFONT,1
	dc.b	IE_SOLIDRECT,42+XO,58+YO,197+XO,80+YO
	dc.b	IE_STRINGADDR,44+XO,69+YO
linkdest: dc.l	0
	dc.b	IE_STRING,44+XO,61+YO,LINK_DESTFOLDER
	dc.b	IE_END

strOriginal dc.b LINK_ORIGINALFOLDER

cbKeepFolders:
	dc.b	1
	dc.b	0
	dc.b	44+XO,49+YO,LINK_KEEPOF

	ds.w	0
ieDrawName:
	dc.b	IE_STRING,123+XO,55+YO,"         ",0
	dc.b	IE_STRINGADDR,123+XO,55+YO
ieName	dc.l	0
	dc.b	IE_END

ieReceiveDirectory:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+XO,40+YO,189+XO,80+YO,LINK_RECEIVEDIR
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,60+XO,55+YO,LINK_RECEIVING
	dc.b	IE_END

	ds.w	0

ieRequestVar:
	dc.b	IE_ANIMEDWIN2,0,50+XO,35+YO,189+XO,90+YO,MNU_LINK_RECEIVE
	dc.b	IE_SETFONT,1
	dc.b	IE_NOP
	dc.b	IE_STRINGADDR,60+XO,55+YO
srclink	dc.l	0
	dc.b	IE_NOP
	dc.b	IE_STRINGADDR,60+XO,71+YO
dstlink	dc.l	0
	dc.b	IE_STRING,60+XO,47+YO,LINK_REC
	dc.b	IE_STRING,60+XO,63+YO,LINK_TO
	dc.b	IE_END


sl_Interface:
	dc.b	IE_SOLIDRECT,2,21,82,119+LH
	dc.b	IE_END

slf_Interface:
	dc.b	IE_SOLIDRECT,84,21,237+LW,119+LH
	dc.b	IE_END

str_link dc.b	17,LSTY,LINK_STR
str_back dc.b	95,LSTY,"[...]",0

ieLinkMenuBar:
	dc.b	IE_SETFONT,0
	dc.b	IE_SOLIDRECT,10,1,225+LW,10
	dc.b	IE_STRING,11,4,MNU_LINK
	dc.b	IE_INVERTAREA,11,2,214+LW,8
	dc.b	IE_SETFONT,1
	dc.b	IE_END

mnuLinkData:
	dc.b	MNU_LINK_RECEIVE
	dc.b	MNU_BAR
	dc.b	MNU_TOOLS_SELECT
	dc.b	MNU_TOOLS_SELECTALL
	dc.b	MNU_TOOLS_DESELECT
	dc.b	MNU_BAR
	dc.b	MNU_FILE_EXIT	

	ds.w	0



