;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		style_g1.xas
;	Utility>	General routines 1 for styles
;
;-----------------------------------------------------------


;-------------------------------------------------------
;Create the list to show in the screen
;
;input>
;out>   a2.l : addr of new list
;               (or the same if no memory)
;	d1.w : Error Code
;-------------------------------------------------------
sg1_MakeList:
	movem.l d0/d2-d6/a0-a1/a3-a6,-(a7)

	;----------------------------------------
	; Interrupt OFF, make it faster
	;----------------------------------------
	INTERRUPT_OFF

	;----------------------------------------
	; Use an undocumented function of Api92
	;----------------------------------------
	move.w  ListBuf_Hdl(PC),d1      	;Previous hdl
	lea     CB_MakeListFilter(PC),a0	;CB function
	move.w  ListReal_Hdl(PC),d0		;Real Hdl
	moveq.w #1,d2                   	;Mode
	jsr     apilib::vat_CreateBuffer

	;----------------------------------------
	; Check if error
	;----------------------------------------
	tst.w	d1				;Check if error
	bne	MemoryCatcher			;if error, exit
	move.w  d0,ListBuf_Hdl			;Save Handle

	;----------------------------------------
	; Else set returns values
	;----------------------------------------
	bsr     DEREFd0a0			;Get array address
	lea     2(a0),a2			;skip first word
	move.w  (a2),NbItem     	        ;put nb items
	clr.w	d1				;no error

	;----------------------------------------
	; and exit
	;----------------------------------------
\exit	move.l	d1,d4				;Save d1
	INTERRUPT_ON
	move.l	d4,d1				;restore d1
	movem.l (a7)+,d0/d2-d6/a0-a1/a3-a6
	rts


;-------------------------------------------------------
; CallBack function for filter
;Input>	a0.l : addr of VAT to filter
;	d7.w : Handle of output buffer
;Out>
;-------------------------------------------------------
CB_MakeListFilter:
	;----------------------------------------
	; Load some addresses for optimization...
	;----------------------------------------
	lea     AdvFilterProperties(PC),a2
	lea     FilterProperties(PC),a3

	move.l	a0,a4			;save current VAT

	;----------------------------------------
	; If char=0	don't show it
	;----------------------------------------
	tst.b	(a0)
	blt     \noadd

	;----------------------------------------
	;'Hide Strange varnames'
	;----------------------------------------
	btst.b  #2,2(a2)                ;Test 'Hide Strange varnames'
	beq.s   \skip1

	cmp.b   #13,(a0)                ;if first char <13 don't add
	blt     \noadd
;#ifdef TIPLUS
;#else
	cmp.b   #48,(a0)                ;don't add
	bcs.s   \skip1                  ;temporary
	cmp.b   #57,(a0)                ;folders
	bls     \noadd                  ;(0001, 0002.. )
;#endif

	;----------------------------------------
	; If hdl=0 don't show
	;----------------------------------------
\skip1  tst.w   ENTRYHDL(a0)            ;check that hdl!=0
	beq     \noadd

	;----------------------------------------
	; Show or not hidden items
	;----------------------------------------
	btst.b   #HIDE_BIT,VAT_ENTRYFLAG(a0)
	beq.s   \nohide
	btst.b  #2,(a2)			;
	beq	\noadd

\nohide 
	;----------------------------------------
	; Show or not archived items
	;----------------------------------------
;#ifdef TIPLUS
	btst.b  #ARCH_BIT,ENTRYFLG(a0)
	bne.s   \nolock
;#endif
	;----------------------------------------
	; Show or not locked items
	;----------------------------------------
	btst.b  #LOCK_BIT,VAT_ENTRYFLAG(a0)
	beq.s   \nolock            
	btst.b  #2,1(a2)
	beq	\noadd
\nolock

	;----------------------------------------
	; Get item type
	;----------------------------------------
	btst.b  #VAT_FOLDERBIT,VAT_ENTRYFLAG(a4)
	beq.s	\file

	;----------------------------------------
	; If we are in style3 (tree) in file side,
	; NEVER show folders
	;----------------------------------------
	lea	Style3_file(PC),a0
	cmp.l	a0,a6
	beq	\noadd


	;----------------------------------------
	; Here we have a folder > Insert folder
	; in alphabetical order
	;----------------------------------------
	move.w	d7,d0			;Handle of buffer
	bsr	DEREFd0a0		;get addr of buffer
	lea	2(a0),a1		;skip first word
	move.w	(a1)+,d2		;NbItem=default index.
	beq	\insert

	;----------------------------------------
	; If we are in style3 (tree) in folder side,
	; show folders without sorting
	;----------------------------------------
	lea	Style3(PC),a0
	cmp.l	a0,a6
	beq	\insert			;d2 is set, ok

	move.w	d2,d3			;nbitems
	subq.w	#1,d3			;for dbra
	clr.w	d2			;default index

	;----------------------------------------
	; Loop until the folder is at it good
	; place or until there is no more folders
	;----------------------------------------
\floop	btst.b  #VAT_FOLDERBIT,VAT_ENTRYFLAG(a1) ;is it a folder ?
	beq	\insert			;if not more folders, skip
	movem.l	d1-d2/a0-a1,-(a7)
	move.l	#8,-(a7)
	move.l	a4,-(a7)		;cmp strings
	move.l  a1,-(a7)
	TIOS_CALL strcmp
	lea	12(a7),a7
	movem.l	(a7)+,d1-d2/a0-a1
	cmp.w   #0,d0
	bgt	\insert
	
	addq.l #1,d2			;increment index
	lea	VATENTRY_SIZE(a1),a1	;next item
	dbra.s	d3,\floop
	bra	\insert			;insert


	;------------------------------------
	; Here we have a file > insert the file
	;------------------------------------
\file	move.w  VAT_ENTRYHDL(a4),d0     ;Get handle of file
	bsr     DEREFd0a0               ;its address
	bsr     GetFileExt              ;Get file type in d2

	;----------------------------------------
	; Hide strange 'pct' entry when pct is
	; archived
	;----------------------------------------
	btst.b	#2,VAT_ENTRYFLAG-1(a4)
	bne	\noadd

	;----------------------------------------
	; Show or not zipped files
	;----------------------------------------
	btst.b  #2,3(a2)                ;Test 'Zipped Files'
	bne.s	\skipzip
	cmp.w	#EXT_ZIP,d2
	beq	\noadd
\skipzip

	;----------------------------------------
	; Show or not relocated EXE
	;----------------------------------------
	btst.b  #2,4(a2)                ;'Already Relocated EXE'
	bne.s   \norel
	cmp.w	#EXT_LIB,d2
	beq.s	\rel
	cmp.w   #EXT_EXE,d2
	bne.s   \norel
\rel	tst.w   RELOC_OFFSET+2(a0)
	bne	\noadd
\norel

	;----------------------------------------
	; If zipped file, get the right extension
	;----------------------------------------
	cmp.w	#EXT_ZIP,d2		;is zipped  file ?
	bne.s	\nozip
	bsr	GetFileExt_z		;if yes, get extension with Zip support
\nozip					;(d1=VAT_ZIPPED if zippeed file)

	;----------------------------------------
	; Show or not RAM/Archived files
	;----------------------------------------
;#ifdef TIPLUS
	cmp.l   #$03FFFF,a0             ;in RAM ?
	bhi.s   \noram
	btst.b  #2,5(a2)
	beq	\noadd
	bra.s   \ramarch
\noram  btst.b  #2,6(a2)                ;archived
	beq	\noadd
\ramarch
;#endif

	;----------------------------------------
	; Get extension string to insert at
	; the right place, according to Sort
	;----------------------------------------
	lea     apilib::vat_ExtStrIndexTbl,a1
	clr.w   d0
	move.b  0(a1,d2.w),d0           ;Get string index of this extension
	btst.b  #2,0(a3,d0.w)           ;Is this extension checked in the list ?
	beq	\noadd


\add	;===================================================
	;= Now make the order. d2=index
	;===================================================
	move.w	VAT_ENTRYHDL(a4),d0	;Handle of current file
	bsr	DEREFd0a0		;its addr
	move.w	(a0),d4			;its size
	bsr     GetFileExt_z		;get file extension
	jsr     apilib::vat_GetExtStr	;return a1=addr of str (d0=file hdl)
	move.l	a1,a5			;save it

	lea     mnuShortByProperties(PC),a2 ;addr 
	move.w	d7,d0			;Handle of buffer
	bsr	DEREFd0a0		;get addr of buffer
	lea	2(a0),a1		;skip first word

	;----------------------------------------
	; If no items, directly insert item
	;----------------------------------------
	move.w	(a1)+,d2		;NbItem=default index.
	beq.s	\insert

	;----------------------------------------
	; If Sort by Name, directly insert
	; (the VAT is by default sorted by name)
	;----------------------------------------
	btst.b	#2,(a2)			;Short by name ?
	bne.s	\insert			;ok, skip

	;----------------------------------------
	; Else Loop all existing files/folder to 
	; find the right place
	;----------------------------------------
	move.w	d2,d3			;nbitems
	subq.w	#1,d3			;for dbra
	clr.w	d2			;default index

\loop	btst.b  #VAT_FOLDERBIT,VAT_ENTRYFLAG(a1) ;is it a folder ?
	bne.s	\nextitem			;if yes, skip

	move.w	VAT_ENTRYHDL(a1),d0	;get item handle
	bsr	DEREFd0a0		;get its handle
	move.w	(a0),d1			;its size
	move.w	d4,d0			;size of file to insert

	;----------------------------------------
	; Determine which sort to do
	;----------------------------------------
	btst.b  #2,2(a2)
	bne.s   \sksize
	btst.b  #2,3(a2)
	beq.s   \nosize

	;----------------------------------------
	; Sort by size, up or down
	;----------------------------------------
	exg.w   d0,d1
\sksize	cmp.w   d1,d0
	bcs.s	\insert
	bra.s	\nextitem

	;----------------------------------------
	; Sort by extension name
	;----------------------------------------
\nosize	movem.l	d1-d2/a0-a1,-(a7)
	bsr     GetFileExt_z		;get its extension
	move.w	VAT_ENTRYHDL(a1),d0	;get item handle
	jsr     apilib::vat_GetExtStr	;get its associated string
	move.l	a5,-(a7)		;cmp strings
	move.l  a1,-(a7)
	TIOS_CALL strcmp
	addq.l  #8,a7
	movem.l	(a7)+,d1-d2/a0-a1
	cmp.w   #0,d0
	bgt.s   \insert
	
\nextitem
	addq.l	#1,d2			;increment index
	lea	VATENTRY_SIZE(a1),a1	;next item
	dbra.s	d3,\loop

	;----------------------------------------
	; OK, insert item at pos d2
	;----------------------------------------
\insert	move.w	d7,d0			;Handle of buffer
	moveq.w	#VATENTRY_SIZE,d1	;
	move.l	a4,a0			;addr of data
	jsr	apilib::array_InsertItem

	tst.w	d1
	bne	MemoryCatcher

\noadd  clr.w   d0
	rts



;-------------------------------------------------------
;	sg1_DrawFirstItem
;
; Draw the first item of the list, TI92 or [...]
; with the item
;
;Input>	/
;Out>	/
;-------------------------------------------------------
sg1_DrawFirstItem:
	movem.l d0-d2/a0,-(a7)

	lea     titxt(PC),a0
	moveq.w #TI_GFX,d2
	API92_CMPFOLDHDL ListReal_Hdl
	beq.s   \skip
	lea     backtxt(PC),a0
	moveq.w #BACK_GFX,d2
\skip   bsr     printf
	moveq.w #1,d0
	moveq.w #LSTY,d1
	bsr     PutImg
	movem.l (a7)+,d0-d2/a0
	rts



;----------------------------------------------------
; Function used by both Style1 and Style2, because
; their function to draw the list are exactly the
; same, exept some instructions at the beginning.
;Input> d2.w : nb item
;	d5.w : nb var per page
;	a2.l : addr of list
;----------------------------------------------------
sg1_CommonDrawList:
	movem.l	d0-d5/a0-a2,-(a7)	;save registers
	movem.l	d6/d7,-(a7)

	;-------------------------------------------
	; Some calculs to set up variables
	;-------------------------------------------
	move.w  d6,d0			;d0 =
	sub.w   d7,d0			; First item to show
	move.w	d0,d6			;Save first item to show

	move.w  d2,d3			;d3=nb item
	sub.w   d0,d3			;d2=nb item
	mulu.w  #VATENTRY_SIZE,d0
	addq.l  #2,a2			;addr of first entry
	tst.w   d0			;if it don't start from the beginning
	beq.s   \nochg
	lea     -VATENTRY_SIZE(a2,d0.w),a2      ;then a2=first item to show
	addq.w  #1,d3           ;

\nochg	moveq.w #LSTY,d1                ;initial Y pos
	cmp.w	d5,d3 			; 12 item at
	ble.s   \skip                   ; max on
	move.w	d5,d3 			; the screen

\skip	move.w	d5,d4			;nb items to show
	subq.w	#1,d4
	clr.w	d7			;clear for DeleteItem

	;-------------------------------------------
	; Draw first item if needed
	;-------------------------------------------
	tst.w	d6			;if first item (d0=0)
	bne.s   \nofirst
	bsr	DeleteItem
	bsr	DrawFirstItem		;draw first item
	addq.l	#1,d7			;Inc ScreenPos
	addq.l	#1,d6			;Inc CurrentItem
	subq.w	#1,d4			;Dec NbItems
	cmp.w   d5,d3
	bne.s   \nofirst
	subq.w  #1,d3

	;-------------------------------------------
	; Loop that draw each item
	;-------------------------------------------
\nofirst
\loop	bsr	DeleteItem		;first delete item
	tst.w   d3			;if no more files
	beq.s   \skip2			;skip
	bsr	GetItemXY		;get item pos
	bsr	DrawItem		;draw item
	subq.w  #1,d3
	lea     VATENTRY_SIZE(a2),a2
	addq.l	#1,d6
\skip2	addq.l	#1,d7

	dbra.s  d4,\loop
	movem.l	(a7)+,d6/d7

	bsr     ShowComment
	bsr     SelectItem

	bsr     Refresh_UpBar

	movem.l	(a7)+,d0-d5/a0-a2
	rts


;----------------------------------------------------
; 	sg1_ShowComment
;
; That function is called to show comment on a
; file
;
; Input>	/
; Out>		/
;----------------------------------------------------
sg1_ShowComment:
	movem.l d0-d7/a0-a6,-(a7)
	
	bsr     ClearBar

	;-------------------------------------------
	; PLUGIN - FUNCTION 5 - Cursor Moved
	;-------------------------------------------
	moveq.w #5,d4
	bsr     ExecPlugin
	tst.w	d0
	bne	\exitnoi

	INTERRUPT_OFF


	;-------------------------------------------
	; If first item selected allow recursive call
	; and set d0=ListReal_Hdl
	;-------------------------------------------
	tst.w   d6
	bne.s   \nofirst
	moveq.w #1,d3                   ;don't allow recursion
	move.w  ListReal_Hdl(PC),d0     ;for CalcSize. Thus it
	API92_CMPFOLDHDL d0      	;return if it is first item
	beq     \exit                   ;the size of the files in the
	bra.s   \sk                     ;folder, (without nested folders)

	;-------------------------------------------
	; Else if we are on a folder, no recursiv call 
	; and set d0=selected folder hdl
	;-------------------------------------------
\nofirst bsr     GetCurrentVATAddr
	move.w  ENTRYHDL(a0),d0		;Handle of selected item

	bsr     GetItemType
	tst.w   d1			;d1 from GetItemType
	beq.s   \nofold
	
	
	clr.w   d3                      ;allow recursiv call

	;-------------------------------------------
	; Here we are on a folder
	;-------------------------------------------
\sk     clr.l   d2                      ;init d2 for CalcSize
	bsr     CalcSize                ;recursive function
	move.l  a7,a1
	suba.w  #30,a7
	
	clr.w   -(a1)
;#ifdef FRENCH      
	move.l  #'ets ',-(a1)
	move.l  #' oct',-(a1)
;#else
	move.l  #$79746573,-(a1)
	move.w  #$2042,-(a1)
;#endif        
	bsr     ConvStr                 ;convert to a1

	move.l  a1,a2
	bsr     ST_Message
	adda.w  #30,a7
	bra.s   \exit

	;-------------------------------------------
	; Here we are on a file
	;-------------------------------------------
\nofold tst.w   d6                      
	beq.s   \exit

	bsr     DEREFd0a0
	bsr     GetFileExt
	cmp.w   #EXT_STR,d2
	bne.s   \nostr
	addq.l  #3,a0
\strv   moveq.w #65,d0                  ;65 chars at max
	suba.w  #70,a7                  ;create a stack frame
	move.l  a7,a1                   ;destination buffer
	jsr     apilib::CpyStrSpecial
	move.l  a1,a2                   ;for ST_Message
	bsr     ST_Message
	adda.w  #70,a7                  ;delete stack frame
	bra.s   \exit

\nostr  cmp.w   #EXT_TEXT,d2
	bne.s   \notxt
	addq.l  #5,a0
	bra.s   \strv

\notxt  cmp.w   #EXT_PLUG,d2
	beq.s   \comm
	cmp.w	#EXT_EXPR,d2
	beq.s	\expr
	cmp.w	#EXT_MAT,d2
	beq.s	\expr
	cmp.w	#EXT_LIST,d2
	bne.s	\noexpr
\expr	bsr	ShowEXPR1D
	bra.s	\exit

\noexpr	cmp.w   #EXT_EXE,d2
	bne.s   \noasm
	
\comm   clr.l   d0
	move.w  COMMENT_OFFSET+2(a0),d0 ;offset of info
	beq.s   \exit           ;if zero exit

;#ifdef TIPLUS
	lea     2(a0,d0.l),a2
;#else
	lea     0(a0,d0.l),a2
;#endif

	bsr     ST_Message
\noasm

\exit	INTERRUPT_ON

\exitnoi movem.l (a7)+,d0-d7/a0-a6
	rts

;----------------------------------------------------------------
; Function called when ENTER is pressed
;----------------------------------------------------------------
sg1_KeyEnter:
	lea     ListReal_Hdl(PC),a4         ;get addr for opimization

	;-------------------------------------------
	; First item of the list selected ?
	;-------------------------------------------
	tst.w   d6                      ;if first item of the list
	bne.s   \noback                 ;
       
	clr.b   allownewfold            ;allow new folds

	;-------------------------------------------
	; If we are at root, enter in Virtual List mode
	;-------------------------------------------
;#ifdef NSTUB
	API92_FOLDHDL d0
	cmp.w	(a4),d0
;#else
	API92_CMPFOLDHDL (a4)			;if already at root
;#endif
	bne.s	\novlist
	lea	VirtualList(PC),a6		;current style
	bsr	InitStyle
	bra	LoopRDList

	;-------------------------------------------
	; Else look for parent folder
	;-------------------------------------------
\novlist move.w  (a4),d1
	jsr     apilib::nf_IsFolderNested	;get previous hdl
	tst.w   d0				;if nested
	bne.s   \nested				; skip
	API92_FOLDHDL d0
\nested	move.w  d0,(a4)				;new handle in ListReal_Hdl
	bsr     PrintList
	bra     \exit

	;-------------------------------------------
	; if not the first item selected
	;-------------------------------------------
\noback	bsr     GetCurrentVATAddr
	bsr     GetItemType

	tst.w   d1
	beq.s   \file
	cmp.w   #1,d1
	beq     \fold

;	btst.b  #PRT_BIT,ENTRYFLG(a0)   :if we enter in a prt folder
;	beq.s   \notprt
;	bsr     RedrawInterface
;	move.b  #1,allownewfold         ;then don't allow new folds
\notprt bra     \fold


	;-------------------------------------------
	; Here a file was selected
	;-------------------------------------------
\file   move.w  ENTRYHDL(a0),d0         ;file hdl
	move.l  a0,a2
	bsr     DEREFd0a0
	bsr     GetFileExt
	
 	;--------------------------------------
	; Check if need extraction
 	;--------------------------------------
	clr.w   d3                      ;d3=0  : no compression 
	clr.w	d5			;d5=0 :  no compression
	cmp.w   #EXT_ZIP,d2
	bne.s   \nozip

 	;--------------------------------------
	; If yes, look if there is a compression
	; plugin available
 	;--------------------------------------
	move.l	d0,-(a7)		;Save d0.w = hdl of selected item
	moveq.l	#02,d0			;NeedTmpExtract
	move.l	d0,-(a7)		;plugin parameter
	moveq.w #9,d4			;CompressionService
	bsr     ExecPlugin
	addq.l  #4,a7
	move.w	d0,d1
	move.l	(a7)+,d0		;restore d0.w = hdl of selected item
	tst.w   d1
	bne.s	\zipok			;SKIP_PCTPROCESS ?

 	;--------------------------------------
	; if extraction not handled by a plugin
	; indicate that it needs a compression plugin
 	;--------------------------------------
	lea	ieZipPlugin(PC),a0
	bsr	InterfaceEngine
	bsr	RedrawListArea
	bra.s	\nozip

 	;--------------------------------------
	; Extract the file using the plugin
 	;--------------------------------------
\zipok	moveq.l	#03,d0			;TmpExtract
	move.l	d0,-(a7)		;plugin parameter
	moveq.w #9,d4			;CompressionService
	bsr     ExecPlugin
	addq.l  #4,a7
	move.w  d1,d3			;Handle if succesful
	beq.s	\nozip			;if 0
	cmp.l	#3,d3			;or not changed
	bne.s	\zzz			;exit
	clr.w	d3
	beq.s	\nozip

 	;--------------------------------------
	; If successful modify current VAT 
	; entry handle to the extracted hdl
	; (both in the buffer vat and in the
	; real vat)
 	;--------------------------------------
\zzz	move.w	d3,d5			;save hdl of extracted file
	bsr     RealCurrentVat		;
	adda.w  #VAT_ENTRYHDL,a1	;
	move.w  (a1),d1                 ;save previous handle
	move.w  d3,(a1)			;put new handle
	move.w  d1,d3			;

	bsr	GetCurrentVATAddr	;get new VAT entry
	move.l	a0,a2
	move.w	(a1),VAT_ENTRYHDL(a2)	;in both lists

	move.w	(a1),d0			;handle of extracted file
	bsr     DEREFd0a0		;
	bsr     GetFileExt		;get new extension

;#ifdef TIPLUS
	movem.l	d0-d2/a0-a1,-(a7)	;Unlock heap to be able
	move.w	d0,-(a7)		;to run the file
	beq.s	\null
	TIOS_CALL HeapUnlock
\null	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a1
;#endif

\nozip
 	;--------------------------------------
	; PLUGIN - FUNCTION 4 = ENTER Pressed
 	;--------------------------------------
	move.l  d0,-(a7)		;save & push d0.w = handle of selected item
	moveq.w #4,d4                   ;  function 3 = KeyEnter
	bsr     ExecPlugin
	move.l  d0,d1
	move.l  (a7)+,d0
	tst.w   d1
	bne     \exit_file		;test if continue


	;-------------------------------------------
	; run ASM prog ( PLUG,EXE,ASM )
	;-------------------------------------------
;#ifdef TIPLUS
	cmp.w	#EXT_ASM,d2		;nostub
	beq.s	\exec2
;#else
	cmp.w   #EXT_EXE1,d2
	beq.s   \exec   
;#endif
	cmp.w   #EXT_EXE,d2
	beq.s   \exec
	cmp.w   #EXT_PLUG,d2
	bne.s	\noexec
\exec   tst.w   RELOC_OFFSET+2(a0)
	bne.s   \exit_file
\exec2
	bsr	PrepareFileToExec
	tst.w	d0
	beq.s	\exit_file
	bra	ExitWithoutPluginCall


;	bsr	DeleteUnarchivedPlugins		;free memory before execution
;	bsr	Free_ListBuf
;	bsr     ExecFile
;	bsr	RefreshPluginTable
;	bsr	RedrawScreen
;	bra.s   \exit_file


\noexec

	;-------------------------------------------
	; run BASIC prog
	;-------------------------------------------
;#ifdef TIPLUS
	cmp.w	#EXT_PRGM,d2
	bne.s	\no_basic
	bsr	ExecBasic
	bsr	RefreshPluginTable
	bsr	RedrawKeepingStatusBar		;call RedrawListArea
	bra.s	\exit_file
\no_basic
;#endif

	;-------------------------------------------
	; Cannot run libs
	;-------------------------------------------
	cmp.w	#EXT_LIB,d2
	bne.s	\no_lib
	lea	strRunLib(PC),a2
	bsr	ST_Message
	bra.s	\exit_file

	;-------------------------------------------
	; Use association
	;-------------------------------------------
\no_lib	bsr	ExecAssociate

	;-----------------------------------------
	; Exit keyenter routine
	;-----------------------------------------
\exit_file tst.w   d3				;check if file has been extracted
	beq.s   \nozip2

	move.w  ListReal_Hdl(PC),d0
	move.w	d5,d1				;look for hdl
	jsr	apilib::vat_FindHdl
	tst.w	d2				;if error
	beq.s	\rdzip				;exit
	move.w  d3,VAT_ENTRYHDL(a1)		;restore real hdl in VAT
	move.w	d5,-(a7)			;put hdl of buffer on stack
	bsr	_HeapFree			;and free tmp buffer
	addq.l  #2,a7

\rdzip	bsr	RedrawListArea
\nozip2	bra.s   \exit


	;-------------------------------------------
	; Here a folder was selected
	;-------------------------------------------
\fold   move.w  ENTRYHDL(a0),(a4)
	bsr     PrintList
\exit   bra     Loop
\exrd   bra     LoopRDScr



	

;------------------------------------------------
;	Enable/Disable menus
;------------------------------------------------
sg1_MenuItemsStates:
sg1_MIS_1:
	;On a File, no selection
	dc.l	$01010101,$01010101
	dc.w	$0101
	dc.l	$01010101
sg1_MIS_2:
	;On a Folder, no selection
	dc.l	$00010101,$01010000
	dc.w	$0101
	dc.l	$01010101
sg1_MIS_3:
	;selection
	dc.l	$01010101,$01010101
	dc.w	$0101
	dc.l	$01010101
sg1_MIS_4:
	;First item
	dc.l	$00000000,$01000000
	dc.w	$0000
	dc.l	$00010101


sg1_EnableMenus:
	movem.l	d0-d2/a0-a3,-(a7)

	move.w	ListReal_Hdl(PC),d0		;Folder list handle
	bsr	vat_CountSelection	;Check if selection
	tst.w	d0				;if not, jump
	beq.s	\noslct
	lea	sg1_MIS_3(PC),a0
	bra.s	\setstates

\noslct	tst.w	d6
	bne.s	\nofirst
	lea	sg1_MIS_4(PC),a0
	bra.s	\setstates

\nofirst bsr	RealFileIndex			;get item addr
	btst.b	#VAT_FOLDERBIT,VAT_ENTRYFLAG(a1) ;if file, jump
	beq.s	\file
	lea	sg1_MIS_2(PC),a0
	bra.s	\setstates

\file	lea	sg1_MIS_1(PC),a0
\setstates bsr	SetMenuItemsState

\exit	movem.l	(a7)+,d0-d2/a0-a3
	rts


;----------------------------------------------------------
; Get the pos of current item
;Input>	d7.w : 
;Out>	d0.w : X
;	d1.w : Y
;----------------------------------------------------------
sg1_GetItemXY:
	move.w  d7,d1
	lsl.w   #3,d1
	add.w   #LSTY,d1		;Y
	moveq.w	#8,d0			;X
	rts

sg1_PadLeft:
	btst.b	#1,S_MODE(a6)		;if mode=VList
	bne.s	_gloop2
	clr.w   d6
_enter1	bra     KeyEnter

sg1_PadRight:
	tst.w   d6
	beq.s	_gloop2
	btst.b	#0,S_MODE(a6)		;if mode=VList
	beq.s	_enter1			;ok
	bsr     GetCurrentVATAddr
	btst.b  #7,ENTRYFLG+1(a0)       ;folder
	bne.s   _enter1			;if yes >enter
_gloop2	bra	Loop


;------------------------------------------------------
; Jump to a file
;------------------------------------------------------
sg1_GoLetter:
	bsr	sg2_GoLetter
	tst.w	d2
	beq.s	\exit

	move.w  d4,d0           ;save d4
	sub.w   d6,d0           ;d4-d6->d0
	add.w   d0,d7
	cmp.w   #NBVARPERPAGE-1,d7
	ble.s   \nosub          ;=< signed
	moveq.w #NBVARPERPAGE-1,d7
\nosub  cmp.w   #0,d7
	bge.s   \nosub2         ;>= signed
	clr.w   d7
\nosub2

	move.w  d4,d6
	bsr     RedrawList_WML
\exit   bra     Loop

;------------------------------------------------------
;Input>	a2.l : VAT Entry
;	d0.w : X offset
;	d1.w : Y
;------------------------------------------------------
sg1_DrawVATFlags:
	movem.l	d0-d4/a0-a2,-(a7)

	move.w	d0,d4			;save X Offset
	move.b  ENTRYFLG+1(a2),d3       ;d3 = flag


;#ifdef TIPLUS
	;-------------------------------------------
	; Archived Attribute
	;-------------------------------------------
	moveq.w	#'-',d2
	btst.b  #ARCH_BIT,ENTRYFLG(a2)
	beq.s   \noarch
	move.w  #164,d2                 ;char = archived
\noarch	move.w	#XATTR_LOCK,d0
	add.w	d4,d0			;add offset
	bsr     printchar

	cmp.w	#164,d2			;if it was archived,
	beq.s	\nolock			;don't show LOCK attribute
;#endif
 

	;-------------------------------------------
	; Locked Attribute
	;-------------------------------------------
	moveq.w	#'-',d2
	btst.b  #LOCK_BIT,d3    ;if file locked
	beq.s   \nolock
	moveq.w #14,d2          ;char = lock
\nolock	move.w	#XATTR_LOCK,d0
	add.w	d4,d0			;add offset
	bsr     printchar


	;-------------------------------------------
	; Hidden Attribute
	;-------------------------------------------
	moveq.w	#'-',d2
	btst.b  #HIDE_BIT,d3
	beq.s   \nohide
	moveq.w #72,d2          ;char=I
\nohide	move.w	#XATTR_HIDE,d0
	add.w	d4,d0			;add offset
	bsr     printchar

	movem.l	(a7)+,d0-d4/a0-a2
	rts

;------------------------------------------------------
;Input>	a2.l : VAT entry
;	d0.w : 0 = Style1, else Style3
;	d1.w : Y
;Out>	d2.w : ExtID
;------------------------------------------------------
;#ifdef TI89
XATTR_LOCK	equ	137
XATTR_HIDE	equ	143
XINFO_SIZE	equ	90
XINFO_EXT	equ	115
XINFOS3_SIZE	equ	95
XINFOS3_EXT	equ	122
;#else
XATTR_LOCK	equ	210
XATTR_HIDE	equ	216
XINFO_SIZE	equ	100
XINFO_EXT	equ	150
XINFOS3_SIZE	equ	157
XINFOS3_EXT	equ	197
;#endif



sg1_DrawFileInformation:
	movem.l	d0-d1/d3-d4/a0-a2,-(a7)

	move.w	d0,d4			;save mode

	move.w  ENTRYHDL(a2),d0		;File Handle
	bsr     DEREFd0a0		;File Address

	;-------------------------------------------
	; Show File Size
	;-------------------------------------------
	move.w  (a0),d2			;SIZE OF FILE
	addq.w  #2,d2			;+2
	moveq.w	#XINFO_SIZE,d0		;X for PrintNumber
	tst.w	d4
	beq.s	\s1_1
	move.w	#XINFOS3_SIZE,d0	;X for PrintNumber
\s1_1	bsr     PrintNumber		;print size


	;-------------------------------------------
	; Get extension of file, supporting 
	; Zipped files
	;-------------------------------------------
	move.l	d1,-(a7)		;Save d1=Y

	bsr     GetFileExt_z		;Get file extension
	tst.w	d1			;Check if zipped or not
	beq.s	\no_zip

	move.l	(a7),d1			;restore d1=Y for printchar
	move.l	d2,-(a7)
	move.w  #'Z',d2			;char >o<
;#ifdef TI89
	move.w  #130,d0
;#else
	move.w  #180,d0
;#endif
	tst.w	d4
	beq.s	\s1_2
;#ifdef TI89
	move.w	#118,d0
;#else
	move.w	#190,d0
;#endif
\s1_2	bsr     printchar
	move.l	(a7)+,d2

\no_zip	move.l	(a7)+,d1		;restore d1=Y

	;-------------------------------------------
	; Show file extension
	;-------------------------------------------
	move.w  ENTRYHDL(a2),d0		;Handle of file
	; beq	ErrorCatcher
	jsr     apilib::vat_GetExtStr	;return a1=addr of str
	move.w	#XINFO_EXT,d0
	tst.w	d4
	beq.s	\s1_3
	move.w	#XINFOS3_EXT,d0
\s1_3	bsr     PrintSp			;a1 & d1 are already set

	movem.l	(a7)+,d0-d1/d3-d4/a0-a2
	rts


;---------------------------------------------------
;Refresh UpBar
;
; refresh memory free on tool bar and 
;---------------------------------------------------
sg1_RefreshUpBar:
	movem.l d0-d5/a0-a2,-(a7)

	INTERRUPT_OFF

	clr.w   d1
	bsr     FontSet

	lea     UpBarRct(PC),a0         ;clear old bar
	bsr     DrawRect

	;-----------------------------------
	; Check if true VAT
	;-----------------------------------
	btst.b	#0,S_MODE(a6)
	beq.s	\noname

	;-----------------------------------
	; If yes, show selected filename as
	; folder\file
	;-----------------------------------
	suba.w	#40,a7
	move.l	a7,a0
	move.w	ListReal_Hdl(PC),d0
;#ifdef TI89
	moveq.w	#15,d1
;#else
	moveq.w	#30,d1
;#endif
	jsr	apilib::nf_GetFolderName
	tst.w	d1
	bne.s	\skip
	move.l	a0,a1
        moveq.l #90,d0
        moveq.l #15,d1
        bsr     PrintSp
\skip	adda.w  #40,a7

\noname	bsr	DrawFreeRAM
	
	moveq.w #1,d1
	bsr     FontSet

	INTERRUPT_ON

	movem.l (a7)+,d0-d5/a0-a2
	rts

