;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : Library Information Plugin
;=====================================================================

	include "tios.h"
	include	"APILib.h"
	include "APILibCT.h"

	xdef    _main                   ;normal assembly program
	xdef    _comment

;#ifdef TIPLUS
;#ifdef TI89
	xdef	_ti89
;#else
	xdef	_ti92plus
;#endif
;#endif

;#ifdef TI89
OX	equ	-40
OY	equ	-10
XO	equ	-40
YO	equ	-10
;#else
XO	equ	0
YO	equ	0
OX	equ	0
OY	equ	0
;#endif


	include "pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	0		;used only by key_enter, draw_item,...
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	KeyPressed		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	HideMenu		;use_menu

;-----------------------------------------------------
; Normal launch of program
;-----------------------------------------------------
END_PLUGIN_TABLE:
	lea	ieAbout(PC),a0
	jsr	apilib::InterfaceEngine
	rts


;-----------------------------------------------------
; Plugin Function :	called to see if it shows
;			the menu or not
;-----------------------------------------------------
HideMenu:
	move.l	$8(a0),a1		;addr of STYLE
	btst.b	#0,(a1)			;
	beq.s	\nomenu			;if no true VAT

	move.w	$10(a0),d0		;Handle of selected item
	beq.s	\nomenu

	bsr	CheckExtension
	tst.w	d0
	beq.s	\nomenu	

\menu	rtplugin SKIP_NEXTPLUGINS
\nomenu rtplugin SKIP_PCTPROCESS+SKIP_NEXTPLUGINS

;-----------------------------------------------------
;Check if good extension
;Input>	d0 = file handle
;Out>	d0=1 ok, 0 if not
;-----------------------------------------------------
CheckExtension:
	movem.l	d1-d2/a0-a1,-(a7)

	tst.w	d0
	beq.s	\error
	jsr	apilib::DEREFd0a0
	jsr	apilib::vat_GetFileExt	;get its extension

	moveq.w	#1,d0
	cmp.w	#EXT_LIB,d2		;if lib
	beq.s	\ok
	cmp.w	#EXT_PLUG,d2
	beq.s	\ok
	cmp.w	#EXT_EXE,d2		;or EXE
	beq.s	\ok

\error	clr.w	d0
\ok	movem.l	(a7)+,d1-d2/a0-a1
	rts


;-----------------------------------------------------
; Plugin Function :	called when a key is pressed
;			in PCT98
;-----------------------------------------------------
KeyPressed:
		move.l	$8(a0),a1		;addr of STYLE
		btst.b	#0,(a1)			;
		beq.s	exiterr			;if no true VAT

		cmp.w	#273,2(a0)		;Test if [F6]
		beq.s	GetLibs			;
exiterr		rtplugin 0

MenuFunction:
GetLibs:
		;-----------------------------
		; Check if right extension
		;-----------------------------
		move.w	$10(a0),d0		;handle of selected item
		bsr	CheckExtension
		tst.w	d0
		beq	exiterr

		;-----------------------------
		; Create buffer
		;-----------------------------
		moveq.w	#14,d1
		jsr	apilib::array_Create
		move.w	d0,d4
		beq.s	\exit

		;-----------------------------
		; Get required libs
		;-----------------------------
		move.w	$10(a0),d0		;Handle of selected item
		move.w	d4,d2
		jsr	apilib::util_GetRequiredLibraries

		;-----------------------------
		; Check that at least one 
		; required lib, else exit
		;-----------------------------
		move.w	d4,d0
		jsr	apilib::DEREFd0a0
		lea	2(a0),a1
		move.w	(a1)+,d2
		beq.s	\nolib

		;-----------------------------
		; Draw interface
		;-----------------------------
		lea	ie_Interface(PC),a0
		jsr	apilib::InterfaceEngine


;Use the ListView component of Api92. It is a very powerful and easy-to-use
;component to draw lists with scrolling if needed

		lea	ListViewHeader(PC),a0
		move.w	d2,(a0)			;nb items
		jsr	apilib::ListViewComponent

		moveq.w	#REDRAW_SCREEN+SKIP_NEXTPLUGINS,d5

		;-----------------------------
		; free tmp handle
		;-----------------------------
\skip		move.w	d4,-(a7)
		beq.s	\nodel
		jsr	tios::HeapFree
\nodel		addq.l	#2,a7

\exit	  	rtpluginDx d5


		;-----------------------------
		; Show 'no library needed'
		;-----------------------------
\nolib		pea	strNoLib(PC)
		jsr	tios::ST_helpMsg
		clr.w	-(a7)
		jsr	tios::ST_busy
		addq.l  #2+4,a7

		;-----------------------------
		; SKIP_PCTPROCESS : don't
		; redraw status bar
		;-----------------------------
		moveq.w	#SKIP_NEXTPLUGINS+SKIP_PCTPROCESS,d5
		bra	\skip

;-----------------------------------------------------
; Callback function used by the ListViewComponent
; component
; Draw the library name, with a mark if it is 
; not on the calc
;-----------------------------------------------------
api92CB_lvDrawItem:
		movem.l	d0-d1,-(a7)

		add.w	#20,d0
		jsr	apilib::draw_StringSpecial

		move.l	a1,a0
		jsr	apilib::vat_FindVarEverywhere

		lea	gfx_1(PC),a0
		tst.w	d0
		bne.s	\found
		addq.l	#8,a0
\found		movem.l	(a7)+,d0-d1
		addq.w	#6,d0
		jsr	apilib::draw_GFX8x8
	
		clr.w	d0
		rts


;====================================================================
; Plugin Data
;====================================================================

ListViewHeader:
		dc.w	0		;NbItem
		dc.w	4		;NbItemPerPage
		dc.w	70+XO		;X
		dc.w	50+YO		;Y
		dc.l	0		;reserved
		dc.w	88		;Width
		dc.w	14		;Constant size
		dc.w	0		;Constant Height
		dc.b	%01000011,0	;flags
		dc.l	0
		dc.l	0
		dc.l	0
		dc.l	api92CB_lvDrawItem
		dc.l	0


gfx_1:
	dc.b	%00000000
	dc.b	%00111100
	dc.b	%01011110
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%00111100
	dc.b	%00000000
	dc.b	%00000000

gfx_2:
	dc.b	%00000000
	dc.b	%00111100
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%00111100
	dc.b	%00000000
	dc.b	%00000000

gfx_3:
	dc.b	%00000000
	dc.b	%00000000
	dc.b	%00110000
	dc.b	%01001000
	dc.b	%01111000
	dc.b	%01001000
	dc.b	%00000000
	dc.b	%00000000


ie_Interface:	dc.b	IE_ANIMEDWIN2,50,60+XO,30+YO,180+XO,94+YO,"LibInfo v1.0.6 - Ibrahim",0
		dc.b	IE_SETFONT,0
		dc.b	IE_STRING,65+XO,43+YO,"Library Used :",0
		dc.b	IE_SETFONT,1
		dc.b	IE_END

ieAbout:	dc.b		IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"LibInfo Plugin",0
		dc.b		IE_SETFONT,1
		dc.b		IE_STRING,58+OX,53+OY,"LibInfo Plugin",0
		dc.b		IE_SETFONT,0
		dc.b		IE_STRING,58+OX,66+OY,"for Pctools, release 1.0.6",0
		dc.b		IE_STRING,58+OX,72+OY,"Ibrahim/Benoit Scherrer",0
		dc.b		IE_SOLIDRECT,58+OX,62+OY,178+OX,63+OY
		dc.b		IE_WAITKEY
		dc.b		IE_END


MenuString	dc.b	"Required Libraries",0,"F6",0

strNoLib	dc.b	"Library used: None",0

_comment
	dc.b    "LibInfo Pctools Plugin",0

	end

