;-----------------------------------------------------------
; 
;	Api92/Api89 Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		runprog.xas
;	Utility>	execute a prog
;
;-----------------------------------------------------------

;========================================================================
; Procedure : HRESULT RunProg ( char *ProgName )
;
; > run a program as if it were launch from the HOME
;
; (c) Benoit SCHERRER, Ibrahim
;========================================================================
SF_errNo	equ	-64
SF_errOffset	equ	-62
SF_hTokenized	equ	-66
SF_ErrFrame	equ	-60

apilib@006D:
_RunProg:
;#ifdef TIPLUS
	link.w 	a6,#-68
	movem.l	d2-d7/a0-a6,-(a7)


	TIOS_ADDR 	top_estack,d6				;save estack
	clr.w		d4					;HRESULT
	clr.w		d3					;errCode


	;-----------------------------------------
	; Get current folder in a stack frame
	; in order to set it as current folder
	;-----------------------------------------
	suba.w		#20,a7			;create stack frame
	move.l		a7,a3			;its address

	clr.b		(a3)+			;TIOS string
	move.l		a3,-(a7)
	TIOS_CALL 	FolderGetCur
	addq.l		#4,a7

	;-----------------------------------------
	; Construct folder to set
	;-----------------------------------------
	lea		9(a3),a1
	clr.b		(a1)+			;TIOS string
	move.l		8(a6),a0
\folder	move.b		(a0)+,d0
	beq.s		\exfolder
	cmp.b		#'\',d0
	beq.s		\exfolder
	move.b		d0,(a1)+
	bra.s		\folder
\exfolder clr.b		(a1)

	;-----------------------------------------
	; Set current folder
	;-----------------------------------------
	clr.l		-(a7)
	move.l		a1,-(a7)		;point to end of string
	TIOS_CALL 	FolderCur
	addq.l		#8,a7


	;-----------------------------------------
	; Create a hProgram
	;-----------------------------------------
	move.l		#80,-(a7)				;Alloc heap
	TIOS_CALL 	HeapAlloc
	addq.l		#4,a7
	move.w		d0,d7					;save handle 
	beq		\end

	bsr		DEREFd0a0			;Copy file name
	move.l		8(a6),a1
\cpy	move.b		(a1)+,(a0)+
	bne.s		\cpy

	;-----------------------------------------
	; Install error catcher
	;-----------------------------------------
	pea 		SF_ErrFrame(a6)			;create stack frame
	TIOS_CALL 	ER_catch
	addq.l 	#4,a7
	tst.w 		d0
	bne 		\catch_error

	;-----------------------------------------
	; Execute program
	;-----------------------------------------
	TIOS_CALL 	OSDisableBreak

	pea		SF_errOffset(a6)			;errOffset
	pea		SF_errNo(a6)				;errNo
	move.w		d7,-(a7)				;Handle
	TIOS_CALL 	NG_tokenize
	lea		10(a7),a7
	cmp.w		#1,d0
	bne		\ex2

	TIOS_CALL 	HS_popEStack
	move.w		d0,SF_hTokenized(a6)			;save it
	clr.w		-(a7)					;NG_DONT_APPROXIMATE
	move.w 		d0,-(a7)				;Handle
	TIOS_CALL 	NG_execute
	addq.l		#4,a7

	;-----------------------------------------
	; Get HRESULT if needed
	;-----------------------------------------
	TIOS_ADDR	top_estack,d0
	cmp.l		d0,d6
	beq.s		\skip
	TIOS_CALL 	HS_popEStack
	move.w		d0,d4					;HRESULT
\skip	TIOS_CALL 	ER_success
	clr.w		d3					;errCode=no error
	bra.s		\exit

	;-----------------------------------------
	; Go here if an error occured
	;-----------------------------------------
\catch_error
	clr.w 		-(a7)
	move.w 	d0,-(a7)
	move.w		d0,d3
	TIOS_CALL 	ERD_dialog
	addq.l 	#4,a7

	;-----------------------------------------
	; Exit function => free memory
	;-----------------------------------------
\exit	pea		SF_hTokenized(a6)
	TIOS_CALL 	HeapFreeIndir
	addq.l		#4,a7
\ex2	move.w		d7,-(a7)
	TIOS_CALL 	HeapUnlock
	TIOS_CALL 	HeapFree
	addq.l		#2,a7
	TIOS_CALL 	OSEnableBreak
;#ifdef NSTUB
	TIOS_LEAADDR	top_estack,a0
	move.l		d6,(a0)
;#else
	move.l 	d6,tios::top_estack		;restore estack
;#endif
	TIOS_CALL 	reset_control_flags
	TIOS_CALL 	cmd_disphome
	clr.L		d0
	trap		#1
	TIOS_CALL 	GKeyFlush

\end
	;-----------------------------------------
	; Set current folder
	;-----------------------------------------
	clr.l		-(a7)			;FALSE
\eos	tst.b		(a3)+			;Get end of string
	bne.s		\eos
	subq.l		#1,a3
	move.l		a3,-(a7)		;push it
	TIOS_CALL 	FolderCur
	addq.l		#8,a7

	adda.w		#20,a7					;delete stack frame

	move.w		d4,d0					;HRESULT
	move.w		d3,d1					;errCode
	movem.l		(a7)+,d2-d7/a0-a6
	unlk 		a6
;#endif
	rts


