;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		style3.xas
;	Utility>	Routines for style3 show (Folder Side)
;
;-----------------------------------------------------------

Style3:
	dc.b	%00000001,0
	dc.l	s3_CreateFolderBuffer
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	s3_DrawItem
	dc.l	s3_DrawFirstItem
	dc.l	s3_PadDown
	dc.l	s3_PadUp
	dc.l	s1_SelectItem
	dc.l	s1_ClearList
	dc.l	s3_DeleteItem
	dc.l	s3_ShowComment
	dc.l	s3_KeyEnter
	dc.l	sg1_EnableMenus
	dc.l	sl_DrawInterface
	dc.l	s3_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	s3_PadLeft
	dc.l	s3_PadRight
	dc.l	sg2_OtherKey
	dc.l	s3_BeforeDrawingList
	dc.l	s3_RedrawListArea
	dc.l	sg1_RefreshUpBar

XREF equ 4
MAXWIDTH equ 12

COLLAPSE_FLAG	equ	2
	
s3_Nothing:
	rts

;#ifdef TIPLUS
;#else
tios::HeapUnlock:
tios::HeapLock:
	rts
;#endif


; folder_hdl : Handle of Folder Side. Deleted only when it is 
;		modified. (folder_hdl in link.mdl)
; Save:		folder_d6
;		folder_d7
;		folder_nb

;****************************************************************
;================================================================
; Universal Functions used by Style3
;================================================================
;****************************************************************


;-------------------------------------------------------------------------
; Give the focus to Folder Side
;-------------------------------------------------------------------------
tree_SetFocusOnFolder:
	move.w	ListReal_Hdl(PC),file_lasthdl
	;------------------------------------
	; Save file pos
	;------------------------------------
	lea	file_d6(PC),a0
	move.w	d6,(a0)+
	move.w	d7,(a0)+

_tree_SetFocusOnFolder:				;used for ShowComment->don't modify file_lasthdl
	bsr	Free_ListBuf			;free ListBuf_Hdl handle
	lea	Style3(PC),a6



	;------------------------------------
	; Restore folder pos
	;------------------------------------
	lea	folder_hdl(PC),a0
	move.w	(a0)+,ListReal_Hdl	;don't forget to refresh ListReal_Hdl with folder_hdl
	move.w	(a0)+,d6
	move.w	(a0)+,d7
	move.w	(a0)+,NbItem

	rts


RedrawTreeList:

	rts

;---------------------------------------------------------
;Draw a clipped string on the string
;
;a1.l : VAT entry 
;d1.w : Y
;d0.w : Level
;Out>	d0.w : X
;---------------------------------------------------------
DrawClippedString:
	movem.l	d1-d7/a0-a4,-(a7)

	;------------------------------------
	; get strlen in d3
	;------------------------------------
	move.l	a1,a0
	clr.l	d3
\strlen	tst.b	(a0)+
	beq.s	\eos
	addq.l	#1,d3
	bra.s	\strlen

	;------------------------------------
	; some saves
	;------------------------------------
\eos	addq.l	#1,d3		;for gfx
	move.w	d3,d7		;size of stack frame
	bclr.l	#0,d7
	suba.w	d7,a7
	move.l	a7,a3
	move.l	a7,a2
	move.w	d0,d5		;level
	addq.w	#1,d5		;for gfx

	;------------------------------------
	; if Level >= 0
	;------------------------------------
	cmp.w	#0,d0
	blt.s	\skip

	cmp.w	#MAXWIDTH-1,d0
	bhi.s	\exit
	mulu.w	#6,d0
	add.w	#XREF,d0

	;------------------------------------
	; Draw GFX
	;------------------------------------
	move.l	d0,-(a7)
	lea	tigfx(PC),a0
	tst.w	d6
	beq.s	\drawgfx
	lea	dirgfx(PC),a0
	move.w	VAT_ENTRYHDL(a1),d0	;folder hdl
	jsr	apilib::nf_GetNestedCount
	tst.w	d2
	beq.s	\drawgfx
	lea	foldp(PC),a0
	btst.b	#COLLAPSE_FLAG,VAT_ENTRYFLAG(a1)
	beq.s	\drawgfx
	lea	foldm(PC),a0
\drawgfx move.l	(a7)+,d0
	jsr	apilib::draw_GFX8x8
	addq.w	#8,d0			;x

\copy1	cmp.w	#MAXWIDTH,d5
	beq.s	\eos2
	move.b	(a1)+,(a3)+
	beq.s	\drawstr
	addq.w	#1,d5
	bra	\copy1
\eos2	clr.b	(a3)+
	bra.s	\drawstr

	;------------------------------------
	; if Level < 0
	;------------------------------------
\skip	clr.w	d4
	sub.w	d5,d4		;make level >0
	cmp.w	d3,d4		;if level > strlen
	bhi.s	\exit		;draw nothing
	add.w	d4,a1		;
	move.l	a1,a2
	moveq.w	#XREF,d0

\drawstr move.l	a2,a1
	jsr	apilib::draw_StringSpecial

\exit	adda.w	d7,a7
	movem.l	(a7)+,d1-d7/a0-a4
	rts


;---------------------------------------------------------
; Get the level of current folder. Encapsulate the 
; GetFolderLevel to test the condition d6.w=0 and
; avoid to call GetCurrentVATAddr in that case
;Input>	/
;Out>	d2.w : Level
;	a0.l : Address of item string
;---------------------------------------------------------
GetCurrentFolderLevel:
	movem.l	d0,-(a7)

	lea	backtxt+2(PC),a0
	moveq.w	#1,d2
	tst.w	d6
	beq.s	\exit			;return d0.w=0 if d6.w=0

	bsr     GetCurrentVATAddr
	move.w	ENTRYHDL(a0),d0		;folder hdl
	bsr	GetFolderLevel

\exit	movem.l	(a7)+,d0
	rts

;---------------------------------------------------------
; Get Level of current folder
; (>=0)
;Input>	/
;Out>	d2.w : Level
;---------------------------------------------------------
GetFolderLevel:
	movem.l	d0-d1,-(a7)
	clr.l	d2
	move.w	d0,d1
	bsr	recGetFolderLevel
	movem.l	(a7)+,d0-d1
	rts

;---------------------------------------------------------
;Recursive subroutine used by GetFolderLevel
;Input>	d1.w : Source Hdl
;	d2.l : Input level
;Out>	d1.w : Parent Handle or 0
;	d2.l : Output level
;---------------------------------------------------------
recGetFolderLevel:
	addq.l	#1,d2
	jsr	apilib::nf_IsFolderNested
	move.w	d0,d1
	beq.s	\exit
	bsr	recGetFolderLevel
\exit	rts	


;---------------------------------------------------------
; Check whether a string is visible or not, according to
; its level
;
;Input>	a0.l : string
;	d0.w : level
;Out>	d0.w : level to add to make it fully visible
;---------------------------------------------------------
LevelVisibleOrNot:
	movem.l	d1/a0,-(a7)

	;------------------------------------
	; get strlen in d1
	;------------------------------------
	clr.l	d1
\strlen	tst.b	(a0)+
	beq.s	\eos
	addq.l	#1,d1
	bra.s	\strlen
	addq.l	#1,d1			;for image

\eos	;------------------------------------
	; If level < 0
	;------------------------------------
	cmp.w	#1,d0
	blt.s	\add1			;if d0<0

	;------------------------------------
	; If level >= 0
	;------------------------------------
	add.w	d1,d0
	cmp.w	#MAXWIDTH-1,d0
	bcs.s	\ok			;<
	sub.w	#MAXWIDTH-1,d0

\exit	movem.l	(a7)+,d1/a0
	rts

\ok:	clr.w	d0
	bra.s	\exit
\add1	subq.w	#1,d0
	bra.s	\exit


;****************************************************************
;================================================================
; STYLE 3 FUNCTIONS
;================================================================
;****************************************************************

;-------------------------------------------
;-------------------------------------------
s3_InitStyle:
	clr.w	d6
	clr.w	d7
	clr.w	level
	bsr	StyleInterface

	lea	folder_d6(PC),a0
	clr.l	(a0)+			;clear folder_d6 & folder_d7
	clr.l	(a0)+			;clear folder_nb & file_lasthdl
	clr.l	(a0)+			;clear file_d6 & file_d7
	clr.w	folder_hdl

	bsr	tree_CreateBuffer

	rts

;------------------------------------------
; Creates the buffer where it puts
; all folders (recursively)
;------------------------------------------
s3_CreateFolderBuffer:
	movem.l	d0-d2/a0-a1,-(a7)

	bsr	tree_CreateBuffer

	move.w	ListReal_Hdl(PC),d0
	beq.s	\exit
	bsr	DEREFd0a0
	lea	2(a0),a2
	move.w	(a2),NbItem

\exit	movem.l	(a7)+,d0-d2/a0-a1
	rts

;---------------------------------------------------------------
; Creates the TREE FOLDER buffer.
;Input>	/
;Out>	d1.w : Error Code
;	Set ListReal_Hdl and NbItem and folder_hdl
;---------------------------------------------------------------
tree_CreateBuffer:
	movem.l	d0/d2-d7/a0-a1,-(a7)

;#ifdef TIPLUS
	; TIOS_CALL HeapCompress
;#endif
	bsr	Free_ListBuf			;free ListBuf_Hdl
	clr.w	folder_hdl

	move.w	folder_hdl(PC),-(a7)
	beq.s	\sk
	bsr	_HeapFree
\sk	addq.l	#2,a7
	clr.w	folder_hdl

	;------------------------------------
	; Create array
	;------------------------------------
	moveq.w	#VAT_ENTRYSIZE,d1		;create list
	jsr	apilib::array_Create
	move.w	d0,d7
	beq	\memerror

	;------------------------------------
	; Get nested buffer addr & lock it
	;------------------------------------
	jsr	apilib::nf_GetBufferAddr		;get nested addr
	tst.w	d0
	beq	\memerror
	move.w	d0,-(a7)			;lock it
	TIOS_CALL HeapLock

	API92_FOLDHDL -(a7)
	TIOS_CALL HeapLock
	move.w	(a7),d0				;restore folder hdl

	bsr	DEREFd0a0			;read folder VAT addr
	lea	2(a0),a1			;skip first word
	move.w	(a1)+,d3			;Nb of folders
	beq.s	\memerror
	subq.w	#1,d3				;for dbra

	;------------------------------------
	; Loop all folders
	;------------------------------------
\loop	move.w	VAT_ENTRYHDL(a1),d6		;folder hdl
	move.w	d6,d1
	jsr	apilib::nf_IsFolderNested
	tst.w	d0
	bne.s	\next
	bsr	AddNestedFolder
\next	lea	VAT_ENTRYSIZE(a1),a1
	dbra.s	d3,\loop


\unlock	TIOS_CALL HeapUnlock		;Unlock folder list
	addq.l	#2,a7
	TIOS_CALL HeapUnlock		;Unlock nested buffer
	addq.l	#2,a7

	move.w	d7,d0				;hdl
	move.w	d0,ListReal_Hdl
	move.w	d0,folder_hdl
	jsr	apilib::DEREFd0a0
	lea	2(a0),a2
	move.w	(a2),NbItem
	clr.w	d1				;no error
	
\exit	movem.l	(a7)+,d0/d2-d7/a0-a1
	rts

\memerror bra	MemoryCatcher


;-------------------------------------------
;recursive function used by CreateFolderBuffer
;input>	d6.w : Folder Handle
;	d7.w : Buffer Handle
;	a1.l : VAT entry associated to d6
;-------------------------------------------
AddNestedFolder:
	movem.l	d0-d4/a0-a2,-(a7)

	;------------------------------------
	; First add VAT entry
	;------------------------------------
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	a1,a0
	bsr	CB_MakeListFilter	;d7=buffer hdl
	movem.l	(a7)+,d0-d7/a0-a6

	;------------------------------------
	; Check if folder open or not
	;------------------------------------
	btst.b	#COLLAPSE_FLAG,VAT_ENTRYFLAG(a1)
	beq.s	\exit

	
	;------------------------------------
	; Get nested buffer to look for nested
	; folders rooted at d6
	;------------------------------------
	jsr	apilib::nf_GetBufferAddr
	tst.w	d0
	beq.s	\exit

	lea	2(a1),a2		;skip first word
	move.w	(a2)+,d3		;nb nested info
	beq.s	\exit
	subq.w	#1,d3			;for dbra

	;------------------------------------
	; Loop to look for nested folders
	;------------------------------------
\loop	cmp.w	(a2),d6			;parent ?
	bne.s	\next
	move.w	2(a2),d1		;look for vat entry 
	API92_FOLDHDL d0		;associated to hdl d1
	jsr	apilib::vat_FindHdl	;its addr = a1
	tst.w	d2
	beq.s	\next

	;------------------------------------
	; If nested folder found, run 
	;  recursiv call
	;------------------------------------
	move.l	d6,-(a7)
	move.w	d1,d6			;new hdl
	bsr	AddNestedFolder		;recursive call
	move.l	(a7)+,d6

\next	lea	4(a2),a2
	dbra.s	d3,\loop

\exit	movem.l	(a7)+,d0-d4/a0-a2
	rts


;-------------------------------------------
;-------------------------------------------
s3_DrawFirstItem:
	lea	titxt+2(PC),a1
	moveq.w	#LSTY,d1
	clr.w	d0
	sub.w	level(PC),d0
	bsr	DrawClippedString
	rts

;-------------------------------------------
; Draw a folder item
;-------------------------------------------
s3_DrawItem:
	movem.l	d0-d4/a0-a4,-(a7)

	move.w	ENTRYHDL(a2),d0		;folder hdl
	bsr	GetFolderLevel		;get level in d2

	move.w	d2,d0			;level in d0
	sub.w	level,d0
	move.w	d0,d2			;save it
	move.l	a2,a1			;string
	bsr	DrawClippedString


\exit	movem.l	(a7)+,d0-d4/a0-a4
	rts

;-------------------------------------------
; Delete an item
;-------------------------------------------
s3_DeleteItem:
	movem.l	d0-d3/a0,-(a7)
	bsr	ItemScrPos
	subq.w	#1,a0

	moveq.w #7,d3           ;delete 8 lines
\line	move.b	#%10100000,(a0)
	moveq.w	#8,d1
\row	clr.b   1(a0,d1.w)
	dbra.s  d1,\row
	lea     30(a0),a0       ;adda.w #30,a0
	dbra.s  d3,\line

	movem.l	(a7)+,d0-d3/a0	
	rts


;-------------------------------------------
; Function called when the user press Pad Down
;-------------------------------------------
s3_PadDown:
	INTERRUPT_OFF
	bsr     SelectItem		;Deselect the current item

	cmp.w   NbItem(PC),d6       
	bne.s	\skip
	clr.w	d6
	clr.w	d7
	clr.w	level
	bra.s	\rd

\skip	addq.w  #1,d6			;IPosScreen
	moveq.w	#1,d4			;RedrawList
	cmp.w   #NBVARPERPAGE-2,d7	;Need scroll ?
	bgt.s   \Scroll			;if no, jump
	addq.w	#1,d7
	clr.w	d4			;No Redraw
\Scroll	bsr	GetCurrentFolderLevel
	move.w	d2,d0			;folder level
	sub.w	level,d0		;
	bsr	LevelVisibleOrNot	;fully Visible ?
	add.w	d0,level
	tst.w	d0
	bne.s	\rd
	tst.w	d4
	bne.s	\rd

	bsr     SelectItem		;Select the item
	bsr     ShowComment		;Comment

\exit	INTERRUPT_ON
	rts

\rd	bsr     RedrawList_WML
	bra.s	\exit


;--------------------------------------------------------
; Function called when the user call PadUP
;--------------------------------------------------------
s3_PadUp:
	INTERRUPT_OFF
	bsr     SelectItem		;Deselect the current item

	tst.w	d6
	bne.s	\skip
	move.w	NbItem(PC),d6
	move.w	#NBVARPERPAGE-1,d7
	cmp.w	d7,d6
	bhi.s	\skip2
	move.w	d6,d7
\skip2	clr.w	level
	moveq.w	#1,d4			;RedrawList
	bra.s	\Scroll

\skip	subq.w  #1,d6			;IPosScreen
	moveq.w	#1,d4			;RedrawList
	tst.w	d7			;Need scroll ?
	beq.s   \Scroll			;if no, jump
	subq.w	#1,d7
	clr.w	d4			;No Redraw
\Scroll	bsr	GetCurrentFolderLevel
	move.w	d2,d0			;folder level
	sub.w	level,d0		;
	bsr	LevelVisibleOrNot	;fully Visible ?
	add.w	d0,level
	tst.w	d0
	bne.s	\rd
	tst.w	d4
	bne.s	\rd

	bsr     SelectItem		;Select the item
	bsr     ShowComment		;Comment

\exit	INTERRUPT_ON
	rts

\rd	bsr     RedrawList_WML
	bra.s	\exit

;-------------------------------------------------------------------------
; Function called when PAD Left is pressed
; UnCollapse folder
;-------------------------------------------------------------------------
s3_PadLeft:
	;--------------------------------------
	; If first item selected directly show
	; Virtual List
	;--------------------------------------
	tst.w	d6
	beq.s	\vlist

	;--------------------------------------
	; Check whether the folder is a parent
	; of a folder
	;--------------------------------------
	bsr     GetCurrentVATAddr
	move.w	VAT_ENTRYHDL(a0),d0
	jsr	apilib::nf_GetNestedCount
	tst.w	d2
	beq.s	\vlist

	;--------------------------------------
	; If yes uncollapse it
	; If already collapsed, come back
	; to virtual list
	;--------------------------------------
	bsr	RealFileIndex
	btst.b	#COLLAPSE_FLAG,VAT_ENTRYFLAG(a1)
	beq.s	\vlist
	bclr.b	#COLLAPSE_FLAG,VAT_ENTRYFLAG(a1)

	bsr	tree_CreateBuffer
	bsr	RedrawList
	
\exit	bra	Loop

\vlist	clr.w	d6
	bra	KeyEnter

;-------------------------------------------------------------------------
; Function called when PAD Right is pressed
; Collapse folder
;-------------------------------------------------------------------------
s3_PadRight:
	tst.w	d6
	beq.s	\exit

	;--------------------------------------
	; Check whether the folder has a nested folder
	;--------------------------------------
	bsr     GetCurrentVATAddr
	move.w	VAT_ENTRYHDL(a0),d0

	btst.b	#COLLAPSE_FLAG,VAT_ENTRYFLAG(a0)	;check if already open
	bne.s	s3_KeyEnter				;if yes, enter the folder

	jsr	apilib::nf_GetNestedCount
	tst.w	d2
	beq.s	s3_KeyEnter

	;--------------------------------------
	; If yes, collapse it
	;--------------------------------------
	bsr	RealFileIndex
	bset.b	#COLLAPSE_FLAG,VAT_ENTRYFLAG(a1)

	bsr	tree_CreateBuffer
	bsr	RedrawList

\exit	bra	Loop

;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3_ShowComment:
	INTERRUPT_OFF

	;--------------------------------------
	; If first item selected, clear panel
	;--------------------------------------
	tst.w	d6
	bne.s	\skip
	bsr	slf_DrawInterface
	bra.s	\exit

\skip	movem.l	d0-d7/a0-a6,-(a7)

	;--------------------------------------
	; Draw FILE side just for comment
	;--------------------------------------
	bsr	tree_SetFocusOnFile
	lea	slf_SelectItemDisabled(PC),a0
	move.l	a0,S_SLCTITEM(a6)
	bsr	RedrawList
	lea	slf_SelectItem(PC),a0
	move.l	a0,S_SLCTITEM(a6)

	;--------------------------------------
	; and give focus to FOLDER side again
	;--------------------------------------
	bsr	_tree_SetFocusOnFolder

	movem.l	(a7)+,d0-d7/a0-a6
	
\exit	INTERRUPT_ON
	rts


;-------------------------------------------------------------------------
; Function called when ENTER is pressed on a folder
; (enter in the folder and gives the focus to file side)
;-------------------------------------------------------------------------
s3_KeyEnter:
	tst.w	d6
	beq.s	\vlist

	bsr	tree_SetFocusOnFile
	bsr	RedrawList

\exit	bra	Loop

\vlist	move.w	folder_hdl(PC),ListBuf_Hdl
	bsr	Free_ListBuf
	clr.w	ListReal_Hdl
	clr.w	folder_hdl

	lea	VirtualList(PC),a6		;current style
	bsr	InitStyle
	moveq.w	#1,d6
	moveq.w	#1,d7
	bsr	RedrawInterface
	bra	LoopRDList


;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3_BeforeDrawingList:
	;-------------------------------
	; firstly make d6 d7 valid
	;-------------------------------
	bsr	s1_BeforeDrawingList

	;-------------------------------
	; And make level valid also
	;-------------------------------
	movem.l d1-d2/a0,-(a7)
	bsr	GetCurrentFolderLevel	;don't bug if d6=0, return a0&d2
	move.w	d2,d0			;folder level
	sub.w	level,d0		;
	clr.w	-(a7)			;create stack frame for a null string
	move.l	a7,a0
	bsr	LevelVisibleOrNot	;fully Visible ?
	addq.l	#2,a7			;delete stack frame
	add.w	d0,level
	movem.l	(a7)+,d1-d2/a0

\exit	rts

;-------------------------------------------------------------------------
; Redraw the two parts of the tree and give focus to folder side
;-------------------------------------------------------------------------
s3_RedrawListArea:
	lea	s1_Interface(PC),a0
	jsr	apilib::InterfaceEngine
	bsr	RedrawList
	bsr	s3_ShowComment
	rts


;-------------------------------------------------------------------------

s3_HDL		dc.w	0
level		dc.w	0
