;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : Change APD Plugin
;=====================================================================

	include "tios.h"                ;library includes files
	include	"APILib.h"
	include "APILibCT.h"

	xdef    _main                   ;normal assembly program
	xdef    _comment

TICKPERSECOND	equ	20

;#ifdef TI89
OX	equ	-40
OY	equ	-10
	xdef	_ti89
;#else
OX	equ	0
OY	equ	0

;#ifdef TIPLUS
	xdef	_ti92plus
;#endif

;#endif

	include "pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	0
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	KeyPressed		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	NOT_USED		;hide_menu

;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:

StartPrgm:
	lea	APDInterface(PC),a0			;Draw nice Window
	jsr	apilib::InterfaceEngine

	;-----------------------------
	; Get current value of APD
	;-----------------------------
	jsr	apilib::util_GetAPD
	move.l	d0,d4
	divu.w	#TICKPERSECOND,d4	;convert in second
	and.l	#$FFFF,d4

Loop
	;-----------------------------
	; Convert it to hh::mm:ss
	;-----------------------------
	move.l	d4,d3
	move.l	d3,d5
	move.l	d3,d6
	move.l	d3,d7

	divu.w	#3600,d7		;hours
	and.l	#$FFFF,d7

	move.l	d3,d6
	move.l	d7,d0
	mulu.w	#3600,d0
	sub.l	d0,d6

	move.l	d6,d5
	divu.w	#60,d6			;minutes
	and.l	#$FFFF,d6
	move.l	d6,d0
	mulu.w	#60,d0
	sub.l	d0,d5			;seconds
	
	;-----------------------------
	; convert in str
	;-----------------------------
	suba.w	#20,a7			;create stack frame
	move.l	a7,a2
	move.w	d5,-(a7)
	move.w	d6,-(a7)
	move.w	d7,-(a7)
	pea	strShowTime(PC)
	move.l	a2,-(a7)
	jsr	tios::sprintf
	lea	14(a7),a7


	;-----------------------------
	; Print it
	;-----------------------------
	moveq.w	#95+OX,d0		;Draw APD value to screen
	moveq.w	#62+OY,d1
	move.l	a2,a1
	jsr	apilib::draw_StringSpecial
	adda.w	#20,a7			;delete stack frame
	
	;-----------------------------
	; Main WaitKey loop
	;-----------------------------
	jsr	apilib::WaitKey			;wait for a key...

						;Here It should be a very small
						;way to see which key was pressed
	moveq.w	#7,d1				;8 loops -1 for dbra
	lea	KeyCodes(PC),a0			;addresses of arrays
	lea	Offsets(PC),a1
\scan	cmp.w	(a0)+,d0
	bne.s	\nokey
	add.w	(a1),d4
\nokey	addq.l	#2,a1
	dbra.s	d1,\scan	

	cmp.w	#10,d4
	bhi.s	\skip1
	moveq.w	#10,d4
\skip1
	cmp.w	#264,d0
	beq.s	\esc

	cmp.w	#13,d0
	bne	Loop

	;-----------------------------
	; Set new value of APD
	;-----------------------------
	move.l	d4,d0
	mulu.w	#TICKPERSECOND,d0
	jsr	apilib::util_SetAPD
\esc	rts

;---------------------------------------------------------------------
; Plugin Function : 	called when a key is pressed
;			in PCT98
;---------------------------------------------------------------------
KeyPressed:
	cmp.w	#KEY_DIAMOND+'T',2(a0)	;<> T
	beq.s	\validkey
	rtplugin 0

\validkey
MenuFunction:
	bsr	StartPrgm
  	rtplugin REDRAW_LIST+SKIP_NEXTPLUGINS



;====================================================================
; Plugin Data
;====================================================================
	ds.w	0
KeyCodes
		;Pad, 	2nd+Pad,   Diam+Pad,  Maj+Pad

;#ifdef TI89
		dc.w	337,340,4096+337,4096+340,8192+337,8192+340,16384+337,16384+340
;#else
		dc.w	338,344,4434,4440,8530,8536,16722,16728
;#endif

Offsets		dc.w	1,$FFFF,10,-10,60,-60,120,-120


APDInterface:	dc.b	IE_ANIMEDWIN2,50,60+OX,40+OY,180+OX,80+OY,"Change APD",0
		dc.b	IE_SETFONT,0
		dc.b	IE_STRING,80+OX,72+OY,"(ESC:Cancel   ENTER:OK)",0
		dc.b	IE_SETFONT,1
		dc.b	IE_STRING,65+OX,53+OY,"APD Timer Value :",0
		dc.b	IE_SETFONT,1
		dc.b	IE_END


strShowTime	dc.b	"%02d:%02d:%02d",0


MenuString	dc.b	"Set APD",0
		dc.b	127,"T",0

_comment dc.b "APD PCT Plugin v1.0.1",0


	end


