;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : Picture Viewer Plugin
;=====================================================================

	include "tios.h"                ;library includes files
	include	"APILib.h"
	include "APILibCT.h"
;#ifdef TIPLUS
	include "ziplib.h"
;#endif
	xdef    _main                   ;normal assembly program
	xdef    _comment

	include "pctplug.h"             ;and after we include pctplug.h


;#ifdef TIPLUS
;#ifdef TI89
	xdef	_ti89
;#else
	xdef	_ti92plus
;#endif
;#endif


;#ifdef TI89
WINWIDTH	equ	159
OX 		equ	-40
OY		equ	-14
;#else
WINWIDTH	equ	239
OX		equ	0
OY		equ	0
;#endif


;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	1,EXT_PIC
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	NOT_USED		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	KeyEnter		;enter_pressed
	dc.l	CursorMoved		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	HideMenu		;hide_menu


;--------------------------------------------------------------------
; Normal launch of program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:
	clr.b	mode
bbb:	clr.w	d7

Loop	jsr	apilib::ZapScreen
	lea	ieInterface(PC),a0
	jsr	apilib::InterfaceEngine

	;---------------------------------
	; Should we show a picture ?
	;---------------------------------
	clr.l	d6				;handle=null

	tst.w	d7
	beq.s	\nodraw
	move.w	d7,d0


;#ifdef TIPLUS
	jsr	apilib::DEREFd0a0
	jsr	apilib::vat_GetFileExt
	cmp.w	#EXT_ZIP,d2
	bne.s	\draw

	move.w	d0,d1
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\nodraw
	move.l	a1,a0			;VAT entry
	moveq.w	#1,d0
	jsr	ziplib::tempfile
	tst.b	d0
	bne.s	\nodraw
	move.w	d1,d6			;Handle of created file
	move.w	d6,d0			;(unzipped)
;#endif

\draw	bsr	DrawPICFile

;#ifdef TIPLUS
	tst.w	d6
	beq.s	\nozip
	move.w	d6,-(a7)
	jsr	tios::HeapFree
	addq.l	#2,a7
	clr.l	d6
\nozip
;#endif
	;---------------------------------
	; WaitKey main loop
	;---------------------------------
\nodraw	jsr	apilib::WaitKey
	cmp.w	#268,d0			;[f1]
	beq.s	SelectFile
	cmp.w	#269,d0
	beq.s	About
	cmp.w	#264,d0
	bne.s	\nodraw

	tst.b	mode
	beq.s	\ex
	rtplugin (SKIP_PCTPROCESS+REDRAW_SCREEN+SKIP_NEXTPLUGINS)
\ex	rts


;-----------------------------------------------------
; About Window
;-----------------------------------------------------
About:
	lea	ieAbout(PC),a0
	jsr	apilib::InterfaceEngine
	jsr	apilib::WaitKey
	bra	Loop

;-----------------------------------------------------
; Select File window
;-----------------------------------------------------
SelectFile:
	lea	ieOpen(PC),a0
	jsr	apilib::InterfaceEngine

	lea	SelectFileHeader(PC),a0
	jsr	apilib::SelectFileComponent
	tst.w	d0
	beq.s	\exit
	move.w	d1,d7
\exit	bra	Loop

	;---------------------------------
	; Filter that show only PIC files
	; and zipped PIC files
	;---------------------------------
api92CB_Filter:
	moveq.w	#1,d0			;d0=1 : Add

	btst.b	#7,VAT_ENTRYFLAG(a0)	;if a folder
	bne.s	\exit			;add it 

	move.w	VAT_ENTRYHDL(a0),d0
	jsr	apilib::DEREFd0a0
	jsr	apilib::vat_GetFileExt
	cmp.w	#EXT_PIC,d2
	beq.s	\exit
	cmp.w	#EXT_ZIP,d2
	bne.s	\noadd

	cmp.b	#11,2(a0)		;if Zipped PIC
	beq.s	\exit			; add it

\noadd	clr.w	d0			;d0=0 : Don't Add

\exit	rts


;-----------------------------------------------------
; Plugin Function :	Menu Function
;-----------------------------------------------------
;-----------------------------------------------------
; Plugin Function :	when the user press
;			ENTER on a PIC in PCT98
;-----------------------------------------------------
MenuFunction:
KeyEnter:
	move.l	$8(a0),a1		;addr of STYLE
	btst.b	#0,(a1)			;
	beq.s	\run			;if no true VAT

	move.w	$10(a0),d7		;Handle of selected item (or nul)
	beq.s	\skip

	move.w	d7,d0			;Check if a PIC file
	jsr	apilib::DEREFd0a0
	jsr	apilib::vat_GetFileExt
	cmp.w	#EXT_PIC,d2
	beq.s	\skip
\run	clr.w	d7			;if not, clear it
\skip	move.b	#1,mode
	bra	Loop

;-----------------------------------------------------
; Plugin Function :	Called to see which string
;			to show in the menu
;-----------------------------------------------------
HideMenu:
	move.l	$8(a0),a1		;addr of STYLE
	btst.b	#0,(a1)			;
	beq.s	\run			;if no true VAT

	move.w	$10(a0),d0		;Handle of selected item
	beq.s	\run
	jsr	apilib::DEREFd0a0
	jsr	apilib::vat_GetFileExt	;get its extension

	lea	mnu_s1(PC),a0
	cmp.w	#EXT_PIC,d2		;if lib
	beq.s	\skip
\run	lea	mnu_s2(PC),a0
\skip	lea	MenuString(PC),a1
\copy	move.b	(a0)+,(a1)+		;copy string
	bne.s	\copy
	clr.b	(a1)+			;no shortcut

\exit	rtplugin SKIP_NEXTPLUGINS



;--------------------------------------------------------------------
; Draw a PIC File
;
;Input>	d0.w : Handle of file
;--------------------------------------------------------------------
DrawPICFile:
	movem.l	d0-d7/a0-a6,-(a7)
	jsr	apilib::DEREFd0a0	;Get its Address
	lea	2(a0),a4		;skip file size

	move.w	(a4)+,d1		;Height of picture
	move.w	(a4)+,d2		;Width of picture

	move.w	d2,d0			;save d2=width in
	move.w	d2,d3			;d0 and d3

	lsr.w	#3,d3			;int(width/8)
	and.w	#7,d0			;
	tst.w	d0
	bne.s	\add			
	subq.w	#1,d3
	
\add	move.l	#LCD_MEM+(30*15),a1
	subq.w	#1,d1			;d1 = Height-1 for dbra
	cmp.w	#110,d1			;Make a vertical clipper
	bls.s	\sizok			;(I found more-than-110
	moveq.w	#110,d1			;height pictures )
\sizok

\YLoop	move.w	d3,d0			;
\XLoop	move.b	(a4)+,(a1)+
	dbra.s	d0,\XLoop
	lea	29(a1),a1
	suba.w	d3,a1
	dbra.s	d1,\YLoop

	movem.l	(a7)+,d0-d7/a0-a6
	rts


;-----------------------------------------------------
; Plugin Function :	when the user select a
;			a PIC file in PCT98
;-----------------------------------------------------
CursorMoved:
	move.w	$10(a0),d0		;Handle of selected file
	jsr	apilib::DEREFd0a0	;Get address of selected file
	addq.l	#2,a0			;skip file size

	suba.w	#64,a7			;create stack frame
	move.l	a7,a2

	move.w	(a0)+,-(a7)
	move.w	(a0),-(a7)
	pea	szInfo(PC)
	move.l	a2,-(a7)
	jsr	tios::sprintf
	lea	12(a7),a7

	move.l  a2,-(a7)
;#ifdef TIPLUS
	jsr	tios::ST_helpMsg
;#else
	jsr     tios::ST_showHelp
;#endif
	addq.l  #4,a7

	adda.w	#64,a7

	rtplugin (SKIP_PCTPROCESS+SKIP_NEXTPLUGINS)


;====================================================================
; Plugin Data
;====================================================================

SelectFileHeader:
	dc.w	72+OX,45+OY	;X,Y
	dc.w	4		;Nb Item per page
	dc.w	95		;Width of the component
	dc.w	0		;Current Folder
	dc.b	%00011000,0	;Flags
	dc.l	api92CB_Filter	;api92CB_Filter
	dc.l	0		;api92CB_lvKeyDown
	dc.l	0		;api92CB_lvKey
	dc.l	0		;api92CB_lvOnSelect
	dc.l	0		;api92CB_lvDrawItem


ieInterface
	dc.b	IE_WIN,0,0,WINWIDTH,14,"Picture Viewer v2.0.3",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,5,8,"[F1]:Open File",0
	dc.b	IE_STRING,68,8,"[F2]:About",0
	dc.b	IE_STRING,120,8,"[ESC]:Exit",0
	dc.b	IE_END

ieOpen	dc.b	IE_ANIMEDWIN,70,70+OX,35+OY,169+OX,85+OY,"Open File",0
	dc.b	IE_SETFONT,1
	dc.b	IE_END

ieAbout	dc.b	IE_ANIMEDWIN2,50,50+OX,35+OY,189+OX,85+OY,"About...",0
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,57+OX,50+OY,"Picture Viewer",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,57+OX,59+OY,"Release 2.0.4",0
	dc.b	IE_STRING,57+OX,76+OY,"(c) NeXO Software, B.SCHERRER",0

	dc.b	IE_END


mode	dc.b	0

szInfo	dc.b	"%dx%d picture",0

MenuString: 
	dc.b 	"                     ",0

mnu_s1:	dc.b	"Edit Picture",0,
mnu_s2:	dc.b	"Run Picture Viewer",0


_comment
	dc.b    "Picture Viewer",0
	end


