;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : Nested Structure Backup
;=====================================================================


	include "tios.h"                ;library includes files
	include	"APILib.h"
	include "APILibCT.h"

	xdef    _main                   ;normal assembly program
	xdef    _comment

TICKPERSECOND	equ	20

;#ifdef TI89
OX	equ	-40
OY	equ	-10
	xdef	_ti89
;#else
OX	equ	0
OY	equ	0

;#ifdef TIPLUS
	xdef	_ti92plus
;#endif

;#endif

ANIMTIMER	equ	50

	include "pctplug.h"             ;and after we include pctplug.h


;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	0
	ds.w	0

PLUGIN_TABLE:
	dc.l	StartOfPct		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	NOT_USED		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	NOT_USED		;hide_menu

;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:

StartPrgm:
	move.b	#ANIMTIMER,ie_Main+1

\rd	lea	ie_Main(PC),a0
	jsr	apilib::InterfaceEngine
	clr.b	1(a0)

\loop	jsr	apilib::WaitKey
	cmp.w	#268,d0
	beq.s	\create
	cmp.w	#269,d0
	beq.s	\restore
	cmp.w	#270,d0
	beq.s	\info
	cmp.w	#264,d0
	bne.s	\loop

\exit	rts

\create	bsr	ConfirmWin
	tst.w	d0
	beq.s	StartPrgm
	bsr	CreateBackupFile
	bra.s	\eop

\restore bsr	ConfirmWin
	tst.w	d0
	beq.s	StartPrgm
	bsr	RestoreBackupFile

\eop	tst.w	d0
	bne.s	\exit
	lea	ie_ok(PC),a0
	jsr	apilib::InterfaceEngine
	bra.s	\exit


\info	lea	win_Info(PC),a0
	jsr	apilib::InterfaceEngine
	bra.s	\rd


;--------------------------------------------------------------------
;  Create the backup of nested structure
;--------------------------------------------------------------------
CreateBackupFile:

	;----------------------------
	; Search backup file
	;----------------------------
	bsr	SearchBackupFile
	tst.w	d2
	beq.s	\notfound

	;----------------------------
	; if valid backup file found
	; delete it
	;----------------------------
	tst.w	d0
	bne	\invalid_file_found
	subq.w	#1,d2
	move.w	#tios::MainHandle,d0
	jsr	apilib::vat_DeleteVar
	tst.w	d1
	bne	\vaterror

	;----------------------------
	; Get the addr of the NF buffer
	;----------------------------
\notfound jsr	apilib::nf_GetBufferAddr
	tst.w	d0
	beq	\nferror

	;----------------------------
	; calc backup file size
	;----------------------------
	move.w	#tios::FolderListHandle,d0
	jsr	apilib::DEREFd0a0
	clr.l	d2
	move.w	2(a1),d2			;nb of long word
	lsl.w	#2,d2			;d0*4  = size
	move.w	2(a0),d0
	mulu.w	#VAT_ENTRYSIZE,d0
	add.w	d0,d2
	add.w	#12,d2			;

	;----------------------------
	; Create file
	;----------------------------
	move.w	#tios::MainHandle,d0		;Folder handle
	clr.w	d1			;flags
	lea	bfile(PC),a0		;filename
	jsr	apilib::vat_CreateVar
	tst.w	d1
	bne.s	\vaterror
	move.w	d0,d7			;save handle

	move.w	(a0),d0
	lea	2(a0,d0.w),a1
	move.b	#$F8,-(a1)
	clr.b	-(a1)
	move.b	#'K',-(a1)
	move.b	#'C',-(a1)
	move.b	#'A',-(a1)
	move.b	#'B',-(a1)
	clr.b	-(a1)
	addq.l	#2,a0

	;----------------------------
	; the addr of the NF buffer
	; may have changed
	;----------------------------
	jsr	apilib::nf_GetBufferAddr	;return in a1

	;----------------------------
	; Copy data in file
	;----------------------------
	;----------------------------
	; firstly, nested info
	;----------------------------
	addq.l	#2,a1
	move.w	(a1),d0
	lsl.w	#2,d0
	addq.w	#2-1,d0
\copy	move.b	(a1)+,(a0)+
	dbra.s	d0,\copy

	;----------------------------
	; secondly, VAT info
	;----------------------------
	move.l	a0,a1
	move.w	#tios::FolderListHandle,d0
	jsr	apilib::DEREFd0a0
	addq.w	#2,a0
	move.w	(a0),d0
	mulu.w	#VAT_ENTRYSIZE,d0
	addq.w	#2-1,d0
\copy2	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy2	


	;----------------------------
	; Archive Backup
	;----------------------------
	move.w	#tios::MainHandle,d0	;search 'nback'
	lea	bfile(PC),a0		
	jsr	apilib::vat_Find
	tst.w	d2
	beq.s	\exit
	subq.w	#1,d2
	jsr	apilib::vat_ArchiveVar
	
\exit	clr.w	d0
\ex	rts

	;----------------------------
	; Error Management
	;----------------------------
\invalid_file_found lea	err_Invalid(PC),a0
	bra.s	\error
\nferror lea	err_nf(PC),a0
\error	moveq.w	#EC_ERRORMESSAGE,d1
\vaterror jsr	apilib::ErrorDialogBox
	moveq.w	#1,d0
	bra.s	\ex
		
;--------------------------------------------------------------------
;  restore nested structure thanks to the 
; backup
;--------------------------------------------------------------------
RestoreBackupFile:
	
	;----------------------------
	; Check if a backup exists
	;----------------------------
	bsr	SearchBackupFile
	move.w	d1,d7
	beq	\err_nobackup
	tst.w	d0
	bne	\invalid_file

	;----------------------------
	; search 'nested' file
	;----------------------------
	move.w	#tios::MainHandle,d0	;search "nested"
	lea	bfile2(PC),a0
	jsr	apilib::vat_Find
	tst.w	d2
	beq.s	\skip

	;----------------------------
	; If found, delete it
	;----------------------------
	subq.w	#1,d2
	jsr	apilib::vat_DeleteVar
	tst.w	d1
	bne.s	\vaterror

	;----------------------------
	; Create new 'nested' buffer
	;----------------------------
\skip	jsr	apilib::nf_GetBufferAddr	;creates buffer
	tst.w	d0
	beq.s	\nferror

	;----------------------------
	; and fill it with valid handle
	;----------------------------
	movem.l	d0-d2/a0-a2,-(a7)
	move.w	d7,-(a7)
	jsr	tios::HeapLock
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a2

	bsr	SearchBackupFile	;get file addr

	addq.l	#2,a0
	move.w	(a0)+,d4		;nb items
	beq.s	\norestore

	move.l	a0,a1
	move.w	d4,d0
	lsl.w	#2,d0			;d0*4
	adda.w	d0,a1			;a1=addr of folder struct

	subq.w	#1,d4

\loop	move.w	(a0)+,d0
	bsr	GetNewHandle
	move.w	d0,d1
	move.w	(a0)+,d0
	bsr	GetNewHandle
	move.w	d0,d2
	beq.s	\next
	tst.w	d1
	beq.s	\next
	jsr	apilib::nf_AddFolder
\next	dbra.s	d4,\loop

\norestore

	movem.l	d0-d2/a0-a2,-(a7)
	move.w	d7,-(a7)
	jsr	tios::HeapUnlock
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a2

\exit	clr.w	d0
\ex	rts

	;----------------------------
	; Error Management
	;----------------------------
\invalid_file lea err_Invalid(PC),a0
	bra.s	\error
\nferror lea	err_nf(PC),a0
	bra.s	\error
\err_nobackup lea err_noback(PC),a0
\error	moveq.w	#EC_ERRORMESSAGE,d1
\vaterror jsr	apilib::ErrorDialogBox
	moveq.w	#1,d0
	bra.s	\ex


;----------------------------------------------------
; Get the new handle of a folder
;Input>	d0.w : Handle of folder
;	a1.l : Previous VAT
;Out>	d0.w : 0 if error
;	else handle new hdl of folder
;----------------------------------------------------
GetNewHandle:
	movem.l	d1-d3/a0-a1,-(a7)

	;----------------------------
	; Look for the handle in the
	; saved VAT
	;----------------------------
	move.w	(a1)+,d3		;nb  folders
	beq.s	\error
	subq.w	#1,d3
\loop	cmp.w	VAT_ENTRYHDL(a1),d0
	beq.s	\found
	lea	VAT_ENTRYSIZE(a1),a1
	dbra.s	d3,\loop
\error	clr.w	d0
	bra.s	\exit

	;----------------------------
	; If found, search new handle
	; according to entry name
	;----------------------------
\found	move.w	#tios::FolderListHandle,d0	;get new handle
	move.l	a1,a0				;of folder
	move.l	a0,-(a7)
	jsr	apilib::vat_Find
	move.l	(a7)+,a0
	tst.w	d2
	bne.s	\nocreate
	move.w	#$0080,d0			;flags
	jsr	apilib::vat_CreateFolder
	tst.w	d1
	bne.s	\error
	bra.s	\exit

\nocreate move.w	VAT_ENTRYHDL(a1),d0

\exit	movem.l	(a7)+,d1-d3/a0-a1
	rts

;----------------------------------------------------
; Look for the backup file
; check if valid
;Input>	/
;Out>	d1.w	Handle of the var if found
;		0 if not found
;	d0.w	0 if valid file
;		1 if invalid file
;	d2.w	1-based index of found var
;	a0.l 	addr of file
;----------------------------------------------------
SearchBackupFile:
	move.l	a1,-(a7)

	;----------------------------
	; Look  for the 'nback' file
	;----------------------------
	move.w	#tios::MainHandle,d0
	lea	bfile(PC),a0
	jsr	apilib::vat_Find
	tst.w	d2
	beq.s	\nofound

	;----------------------------
	; If found,  check signature
	;----------------------------
	move.w	(a0),d0			;size of file
	lea	2(a0,d0.w),a1
	cmp.b	#$f8,-(a1)
	bne.s	\invalid
	cmp.b	#$0,-(a1)
	bne.s	\invalid
	cmp.b	#'K',-(a1)
	bne.s	\invalid
	cmp.b	#'C',-(a1)
	bne.s	\invalid
	cmp.b	#'A',-(a1)
	bne.s	\invalid
	cmp.b	#'B',-(a1)
	bne.s	\invalid
	clr.w	d0			;valid

\exit	move.l	(a7)+,a1
	rts

\nofound move.w	d2,d1
\invalid moveq.w #1,d0			;invalid
	bra.s	\exit

;----------------------------------------------------
; wait for a confirmation of the user
;Input>	/
;Out>	d0.w : 0 = cancel
;	else continue
;----------------------------------------------------
ConfirmWin:
	lea	ie_confirm(PC),a0
	jsr	apilib::InterfaceEngine
\loop	jsr	apilib::WaitKey
	cmp.w	#13,d0
	beq.s	\exit
	cmp.w	#264,d0
	bne.s	\loop
	clr.w	d0
\exit	rts


;---------------------------------------------------------------------
; Function called for the Plugin menu of PCT98
;---------------------------------------------------------------------
MenuFunction:
	bsr	StartPrgm
  	rtplugin (REDRAW_SCREEN+SKIP_NEXTPLUGINS+REFRESH_PLUGIN_TABLE)

StartOfPct:
	;----------------------------
	;Valid backup exists ?
	;----------------------------
	bsr	SearchBackupFile
	tst.w	d1
	beq.s	\exit
	tst.w	d0
	bne.s	\exit

	;----------------------------------
	; find 'nested' var
	; if found check if valid, if not
	; found propose to restore backup
	;----------------------------------
\find	lea	strNested(PC),a0
	move.w	#tios::MainHandle,d0	;Handle of 'Main' folder
	jsr	apilib::vat_Find		;find 'nested' file
	tst.w	d2
	bne.s	\found			;

	;----------------------------------
	; If not found, suggest to restore
	; backup
	;----------------------------------
	lea	ie_AutoRestore(PC),a0
	jsr	apilib::InterfaceEngine
\loopK	jsr	apilib::WaitKey
	cmp.w	#13,d0
	beq.s	\restore
	cmp.w	#264,d0
	beq.s	\exit
	bra.s	\loopK



	;----------------------------
	; Check that all folders are
	; valid in 'nested'
	;----------------------------
\found	jsr	apilib::nf_GetBufferAddr
	tst.w	d0
	beq.s	\exit

	lea	2(a1),a2
	move.w	(a2)+,d3	;nb longword
	beq.s	\exit
	lsl.w	#1,d3		;d3*2
	subq.w	#1,d3		;-1 for dbra

\loop	move.w	(a2)+,d1
	move.w	#tios::FolderListHandle,d0
	jsr	apilib::vat_FindHdl
	tst.w	d2
	beq.s	\error
	dbra.s	d3,\loop	
	bra.s	\exit

\error	lea	ie_start(PC),a0
	jsr	apilib::InterfaceEngine
\restore bsr	RestoreBackupFile

\exit	rtplugin REFRESH_PLUGIN_TABLE



;====================================================================
; Plugin Data
;====================================================================

bfile	dc.b	"nback",0
bfile2	dc.b	"nested",0,0

MenuString dc.b "Nested Structure Backup",0,0


ie_Main	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+OX,35+OY,189+OX,85+OY,"Nested Structure Backup",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,56+OX,77+OY,"release 1.0.3 / Ibrahim",0
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,62+OX,50+OY,"F1:Create Backup",0
	dc.b	IE_STRING,62+OX,58+OY,"F2:Restore Backup",0
	dc.b	IE_STRING,62+OX,66+OY,"F3:What is it ?",0
	dc.b	IE_END

ie_ok	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+OX,35+OY,189+OX,85+OY,"Successful",0
	dc.b	IE_STRING,65+OX,60+OY,"Successful",0
	dc.b	IE_WAITKEY
	dc.b	IE_END

ie_confirm dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+OX,40+OY,189+OX,80+OY,"Warning - Confirmation",0
	dc.b	IE_STRING,55+OX,53+OY,"Are you REALLY sure",0
	dc.b	IE_STRING,55+OX,61+OY,"to do that ?",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,80+OX,72+OY,"enter=ok    esc=cancel",0
	dc.b	IE_END

ie_start dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+OX,35+OY,189+OX,85+OY,"Nested Structure Backup",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,55+OX,52+OY,"The NBackup plugin has found invalid",0
	dc.b	IE_STRING,55+OX,58+OY,"data in the file 'nested'.",0
	dc.b	IE_STRING,55+OX,66+OY,"NBackup is going to try to restore",0
	dc.b	IE_STRING,55+OX,72+OY,"the last nested structure backup.",0
	dc.b	IE_WAITKEY
	dc.b	IE_END

ie_AutoRestore:
	dc.b	IE_ANIMEDWIN2,ANIMTIMER,50+OX,35+OY,189+OX,85+OY,"Nested Structure Backup",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,55+OX,52+OY,"The NBackup plugin has found a backup",0
	dc.b	IE_STRING,55+OX,58+OY,"of nested folders structure.",0
	dc.b	IE_STRING,55+OX,66+OY,"Do you want NBackup to restore it?",0
	dc.b	IE_STRING,70+OX,74+OY,"  [ENTER]=YES  [ESC]=NO",0
	dc.b	IE_END

err_Invalid	dc.b IE_STRING,45+OX,66+OY,"Invalid File 'nback'",0
		dc.b IE_STRING,45+OX,74+OY,"Cannot continue",0
		dc.b IE_END
err_nf		dc.b IE_STRING,45+OX,67+OY,"'nested' file error",0
		dc.b IE_END
err_noback	dc.b IE_STRING,45+OX,67+OY,"No Backup File Found",0
		dc.b IE_END


win_Info	dc.b	IE_WIN2,50+OX,35+OY,189+OX,85+OY,"What is it ?",0
		dc.b	IE_SETFONT,0
		dc.b	IE_STRING,55+OX,48+OY,"NBackup is a plugin for PCTOOLS that",0
		dc.b	IE_STRING,55+OX,54+OY,"saves the nested folder structure in",0
		dc.b	IE_STRING,55+OX,60+OY,"an archived file so that it can be ",0
		dc.b	IE_STRING,55+OX,66+OY,"restored after a reset.",0
		dc.b	IE_STRING,55+OX,74+OY,"Don't forget to use it.",0
		dc.b	IE_WAITKEY
		dc.b	IE_END

strNested	dc.b	"nested",0


_comment dc.b "Nested Structure Backup",0


	end


