#ifndef AFE_H
#define AFE_H

#define MAX_ASCII           256

//Prototypes AFE
int CompressAFE (FILE *input,FILE *output);
int UncompressAFE (FILE *input,FILE *output);

//Application de l'algorithme
void AFE_InitializeTable (unsigned char *car, unsigned char *TableCar, unsigned char *TableHeader);
void AFE_SwapFreq (unsigned long *a, unsigned long *b);
void AFE_SwapCar (unsigned char *a, unsigned char *b);
void AFE_SortTable (unsigned char *TableCar, unsigned char *TableHeader, unsigned long *freq, unsigned char *car);
unsigned char AFE_FindCar (unsigned char *car, unsigned char c);
unsigned char AFE_FindChar2 (unsigned char *TableCar, unsigned char *TableHeader, unsigned char nbit, unsigned char code);

void AFE_Compress (unsigned char *TableCar, unsigned char *TableHeader, unsigned long *freq, unsigned char *car, FILE *input,FILE *output);
void AFE_Uncompress (unsigned char *TableCar, unsigned char *TableHeader, unsigned long *freq, unsigned char *car, FILE *input,FILE *output);

#endif
