//Algorithme de compression et de dcompression LZ77
#include "Header.h"
#include "fonctions.h"
#include "huffman.h"
#include "LZSS.h"

using namespace std;

//Application de l'algorithme de compression
int LZ77_Compress (unsigned char *tampon, FILE *input, FILE *output)
{
  //Dfinition du buffer
  #define buffer (unsigned char *)(tampon+START_BUFFER)
    
  //Variables compression  
  unsigned char read=1;
  unsigned char endread;
  BOOL find;
  
  //Variables temporaires
  unsigned long pos;
  unsigned short size;
  
  //Variables temporaire gestion bit  bit du fichier de sortie
  unsigned char byte=0;
  unsigned char start=0;
  
  //Affichage pourcentage
  unsigned long k=(BUFFER_SIZE*2)-1;
  unsigned char purcent=0, purcent2=0;
  
  //Remplissage buffer
  fread (buffer-BUFFER_SIZE, (BUFFER_SIZE*2)-1, 1, input);
  
  //Ecriture permettant la communication avec le dcompresseur
  for (int i=0; i<BUFFER_SIZE; i++) {
    BitWrite (0, byte, start, BITS_POS, output);
    BitWrite (0, byte, start, BITS_SIZE, output);
    BitWrite (*(unsigned char*)(buffer-BUFFER_SIZE+i), byte, start, 8, output);}
     
  //Parcours fichier
  while (!feof (input))
  {
    //Ajoute caractre
    endread=fread (tampon+TAMPON_SIZE-read, 1, read, input);
    purcent=((unsigned long long)(k+=read)*100)/TPE_FILE.size;
    
    //Dpassement du fichier
    if (endread!=read)
      break;
       
    //Recherche de dfinition
    find=LZ_Find (tampon, buffer, pos, size);
    
    //Recherche russie
    if (find)
    {
      read=size+1;
    
      //Ecriture dans fichier du TRIPLET (pos, size, char suivant)
      BitWrite (pos-1, byte, start, BITS_POS, output);
      BitWrite (size-1, byte, start, BITS_SIZE, output);
      
      //Dapssement du buffer
      if (size>=BUFFER_SIZE)
      {
        memmove (tampon, tampon+1, TAMPON_SIZE-1);
        tampon [END_BUFFER]=fgetc (input);
        
        //Fin du fichier
        if (feof (input)) break;
        k++;
        
        //Ecriture caractre
        BitWrite (tampon [END_BUFFER], byte, start, 8, output);
        read--;
      }
      else
        BitWrite (tampon [START_BUFFER+size], byte, start, 8, output);
    }
    //Recherche choue
    else
    {
      read=1;
      
      //Ecriture dans fichier du triplet
      BitWrite (0, byte, start, BITS_POS, output);
      BitWrite (0, byte, start, BITS_SIZE, output);
      BitWrite (tampon [START_BUFFER], byte, start, 8, output);
    }
    
    //Dcalage tampon
    memmove (tampon, tampon+read, TAMPON_SIZE-read);
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  }
  
  //Ecriture reste buffer
  for (int i=0; i<(BUFFER_SIZE-read)+endread; i++) {
    BitWrite (0, byte, start, BITS_POS, output);
    BitWrite (0, byte, start, BITS_SIZE, output);
    BitWrite (*(unsigned char*)(buffer+i), byte, start, 8, output);}
        
  //Affiche pourcentage restant
  purcent=((unsigned long long)(k+=(BUFFER_SIZE-read)+endread)*100)/TPE_FILE.size;
  printf ("\rCompress in progress... %u%% achieved.", purcent);
   
  //Octet restant
  if (start!=0)
    fputc (byte, output);
}

//Compression mthode de compression LZSS
int CompressLZ77 (FILE *input,FILE *output)
{
  //Ecriture de l'header
  fwrite (&WINDOW_SIZE, 4, 1, output);
  fwrite (&BUFFER_SIZE, 2, 1, output);
  
  //Taille des donnes couple (pos, size)
  BITS_POS=NBitInt (WINDOW_SIZE-1);
  BITS_SIZE=NBitInt (BUFFER_SIZE-1);
    
  //Allocation du tampon
  unsigned char *TAMPON=(unsigned char*)malloc (TAMPON_SIZE);
  //Vide tampon
  memset (TAMPON, 0, TAMPON_SIZE);
  
  printf ("Window size: %lu\n", WINDOW_SIZE);
  printf ("Buffer size: %u\n\n", BUFFER_SIZE);    
  printf ("Compress in progress... 0%% achieved.");
  
  //Compression
  LZ77_Compress (TAMPON, input, output);
  
  //Libre mmoire
  free (TAMPON);
    
  return -1;
}


//Application de l'algorithme de dcompression
int LZ77_Uncompress (unsigned char *tampon, FILE *input, FILE *output)
{
  //Dfinition buffer
  #define buffer (unsigned char *)(tampon+START_BUFFER)
     
  //Variables lecture bit  bit du fichier
  unsigned char byte=fgetc (input);
  unsigned char start=0;
  
  //Variables temporaire
  unsigned long pos;
  unsigned short size;
  
  //Compteur d'octet
  unsigned long counter=BUFFER_SIZE;
  
  //Affichage pourcentage
  unsigned char purcent=0, purcent2=0;
  
  //Remplissage buffer
  for (int i=0; i<BUFFER_SIZE; i++)  {
    BitRead (byte, start, BITS_POS, input);
    BitRead (byte, start, BITS_SIZE, input);
    tampon [START_BUFFER+i]=BitRead (byte, start, 8, input);
    fputc (tampon [START_BUFFER+i],output);}
  
  //Parcours fichier
  while (!feof (input) && (counter!=TPE_FILE.size))
  {
    //Lecture du dbut du TRIPLET position
    pos=BitRead (byte, start, BITS_POS, input);
    
    //CARACTERE
    if (pos==0) 
    {
      //Dcalage d'un caractre du tampon
      memmove (tampon, tampon+1, TAMPON_SIZE-1);
      
      //Saute info size dans TRIPLET
      BitRead (byte, start, BITS_SIZE, input);
      
      //Ajout dans c_buffer
      tampon [END_BUFFER]=BitRead (byte, start, 8, input);
            
      //Ecriture caractre
      fputc (tampon [END_BUFFER], output);
      counter++;
    }
    //COUPLE
    else
    {
      //Lecture du couple
      pos++;
      size=BitRead (byte, start, BITS_SIZE, input)+1;
      
      //Dcalage tampon
      memmove (tampon, tampon+size, TAMPON_SIZE-size);
      
      //Copie dfinition
      memcpy ((tampon+TAMPON_SIZE)-size, tampon+(TAMPON_SIZE-pos)-size, size);
      
      //Ecriture du couple
      fwrite (tampon+(TAMPON_SIZE-pos)-size, size, 1, output);
      
      //Dcalage tampon d'un caractre
      memmove (tampon, tampon+1, TAMPON_SIZE-1);
      
      //Caractre restant
      tampon [END_BUFFER]=BitRead (byte, start, 8, input);
            
      //Caractre restant
      fputc (tampon [END_BUFFER], output);
      counter+=size+1;
    }
    
    //*******************
    //Affiche pourcentage
    //*******************
    purcent=((unsigned long long)counter*100)/TPE_FILE.size;
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  }
}

//Dcompression mthode de compression LZSS
int UncompressLZ77 (FILE *input,FILE *output)
{
  //Lecture de l'header
  fread (&WINDOW_SIZE, 4, 1, input);
  fread (&BUFFER_SIZE, 2, 1, input);
  
  //Taille des donnes couple (pos, size)
  BITS_POS=NBitInt (WINDOW_SIZE-1);
  BITS_SIZE=NBitInt (BUFFER_SIZE-1);
  
  //Allocation du tampon
  unsigned char *TAMPON=(unsigned char *)malloc (TAMPON_SIZE);
  //Vide tampon
  memset (TAMPON, 0, TAMPON_SIZE);
  
  printf ("Window size: %lu\n", WINDOW_SIZE);
  printf ("Buffer size: %u\n\n", BUFFER_SIZE);    
  printf ("Uncompress in progress... 0%% achieved.");
  
  //Dcompression
  LZ77_Uncompress (TAMPON, input, output);
  
  //Libre mmoire
  free (TAMPON);
  
  return -1;
}
