//Algorithme de compression et de dcompression LZH (LZ77+Huffman)
#include "Header.h"
#include "fonctions.h"
#include "huffman.h"
#include "LZSS.h"
#include "LZH.h"

using namespace std;

//Compression LZH
int CompressLZH (FILE *input,FILE *output)
{  
  //Ecriture de l'header
  fwrite (&WINDOW_SIZE, 4, 1, output);
  fwrite (&BUFFER_SIZE, 2, 1, output);
  
  //Taille des donnes couple (pos, size)
  BITS_POS=NBitInt (WINDOW_SIZE-1);
  BITS_SIZE=NBitInt (BUFFER_SIZE-1);
  
  //Allocation du tampon
  unsigned char *TAMPON=(unsigned char*)malloc (TAMPON_SIZE);
  //Vide tampon
  memset (TAMPON, 0, TAMPON_SIZE);   
  
  //Table ASCII final trie
  H_ASCII *Table_ASCII=(H_ASCII *)malloc (sizeof (H_ASCII)*LZ_ASCII_SIZE);
  
  //Variables
  unsigned short DimAscii;        //Nombres de caractres...
  H_Tree *Racine;                 //Pointeur racine de l'arbre
  unsigned char EndTableByte;     //Octet de fin de la table
  unsigned char EndTableStart;    //Dbut de l'octet de fin de la table
  
  printf ("Window size: %lu\n", WINDOW_SIZE);
  printf ("Buffer size: %u\n\n", BUFFER_SIZE);
  printf ("Compress in progress...\n\n");
  
  //Table de frquences
  printf ("Pass 1: Make table of frequency with output characters... 0%% achieved.");
  
  //Efface la table de frquences
  HUFF_ClearTable (Table_ASCII, LZ_ASCII_SIZE);
  
  //Compression passe 0
  LZSS_Compress (TAMPON, Table_ASCII, DimAscii, 0, 0, input, output, Mode_LZH_0);
  
  //Tri les frquences par ordre dcroissant
  printf ("\nSort frequency.");
  HUFF_SortTable (Table_ASCII, LZ_ASCII_SIZE);
  
  //Cration de l'arbre
  printf ("\nMake Tree of Huffman.\n");
  if (!HUFF_MakeTree (Table_ASCII, DimAscii, &Racine)) {
    cerr << "\nError: Out of memory.\n\n";
    free (Table_ASCII);
    //Racine=HUFF_DeleteTree (Racine);
    free (TAMPON);
    return 17;}
      
  //Cration du codage
  printf ("Create code table.\n");
  Racine->code=0; Racine->bits=0;
  HUFF_CreateCode (Table_ASCII, Racine);
  
  //Ecrit la table dans le fichier    
  HUFF_CreateTableInFile (Table_ASCII, DimAscii, LZ_ASCII_SIZE, output, EndTableByte, EndTableStart);
  
  //Repositionne au dbut du fichier
  fseek (input, 0, SEEK_SET);
  
  //Compression passe 2
  printf ("Pass 2: LZSS, created output characters with Huffman codes... 0%% achieved.");
  LZSS_Compress (TAMPON, Table_ASCII, DimAscii, EndTableByte, EndTableStart, input, output, Mode_LZH_1);
  
  /*printf ("%u\n", DimAscii);
  for (int i=0; i<256; i++)
  {
    if (Table_ASCII [i].codifie)
      printf ("%u - %u - %lu\n", i, Table_ASCII [i].bits, Table_ASCII [i].code);
  }*/
  
  //Efface arbre de Huffman
  //Racine=HUFF_DeleteTree (Racine);
  free (Table_ASCII);
  //Libre mmoire
  free (TAMPON);
      
  return -1;
}


//Dcompression LZH
int UncompressLZH (FILE *input,FILE *output)
{
    
  return -1;
}
