//Algorithme de compression et de dcompression RLE2
#include "Header.h"
#include "fonctions.h"
#include "RLE2.h"

using namespace std;

//Mthode de codage:
//------------------
//Codage sur 2 bits du nombres d'occurences.
//Bit tmoins 0 = caractre simple, 1 = rptition de n occurences.
//Codage sur 8 bits du caractre rcurrent.

//Application algorithme de compression RLE
void RLE2_Compress (FILE *input,FILE *output)
{
  unsigned short nbyte=1;                    //Rptition d'octets.
  unsigned char character;                  //Caractre en cours
  unsigned char rchar;                     //Repeat character
  
  //Variables fichier
  unsigned char byte=0;
  unsigned char start=0;
  
  //Affichage pourcentage
  unsigned long k=1;
  unsigned char purcent=0, purcent2=0;
           
  //Prparation de dbut (Premire octet)
  rchar=fgetc (input);
  nbyte=1;
  
  //Parcours fichier
  while (!feof (input))
  {
    //Octet en cours
    character=fgetc (input);
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    //Fin du fichier
    if (feof (input)) break;
        
    //Rptition d'occurences
    if (character==rchar)
    {    
      nbyte++;
      
      //Dpassement de capacit
      if (nbyte==(1<<OCCUR_BITS)+2)
      {
        BitWrite (BIT_OCCUR, byte, start, 1, output);
        BitWrite ((1<<OCCUR_BITS)-1, byte, start, OCCUR_BITS, output);
        BitWrite (rchar, byte, start, 8, output);
                
        //Prpare occurence suivante
        nbyte=1;
      }
    }
    //Fin occurence
    else
    {
      //Rptition
      if (nbyte!=1)
      {
        BitWrite (BIT_OCCUR, byte, start, 1, output);
        BitWrite (nbyte-2, byte, start, OCCUR_BITS, output);
        BitWrite (rchar, byte, start, 8, output);            
                                                                     
        //Compteur initialis
        nbyte=1;
      }
      //Aucune rptition
      else
      {
        BitWrite (BIT_CHAR, byte, start, 1, output);
        BitWrite (rchar, byte, start, 8, output);
      }
      
      rchar=character;
    }
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  }
  
  //Fin d'occurence
  //Rptition
  if (nbyte!=1)
  {
    BitWrite (BIT_OCCUR, byte, start, 1, output);
    BitWrite (nbyte-2, byte, start, OCCUR_BITS, output);
    BitWrite (rchar, byte, start, 8, output);
  }
  //Aucune rptition
  else
  {
    BitWrite (BIT_CHAR, byte, start, 1, output);
    BitWrite (rchar, byte, start, 8, output);
  }
    
  //Ecriture bits restant
  if (start!=0)
    fputc (byte, output);
}

//Compression RLE2
int CompressRLE2 (FILE *input,FILE *output)
{  
  //Ecriture header
  fwrite (&OCCUR_BITS, 1, 1, output);
  
  printf ("Number bits for a occurence: %u\n\n", OCCUR_BITS);
  printf ("Compress in progress... 0%% achieved.");
  
  //Compression RLE2
  RLE2_Compress (input, output);
   
  return -1;
}

//Application algorithme de dcompression RLE
void RLE2_Uncompress (FILE *input,FILE *output)
{
  //Variable fichier
  unsigned char byte=fgetc (input);
  unsigned char start=0;
  unsigned short nchar;
  unsigned char *buffer=(unsigned char *)malloc ((1<<OCCUR_BITS)+1);
  
  //Affichage pourcentage
  unsigned char purcent=0, purcent2=0;
  unsigned long counter=0;
  
  //Parcours fichier
  while (!feof (input) && (counter!=TPE_FILE.size))
  {
    //Rptition d'occurence
    if (BitRead (byte, start, 1, input))
    {
      nchar=BitRead (byte, start, OCCUR_BITS, input)+2;
      memset (buffer, BitRead (byte, start, 8, input), nchar);
      fwrite (buffer, nchar, 1, output);
      counter+=nchar; 
    }
    //Simple caractre
    else {
      fputc (BitRead (byte, start, 8, input), output);
      counter++;}
      
    //*******************
    //Affiche pourcentage
    //*******************
    purcent=((unsigned long long)counter*100)/TPE_FILE.size;
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  }
  
  //Libre mmoire alloue pour buffer
  free (buffer);
}

//Dcompression RLE2
int UncompressRLE2 (FILE *input,FILE *output)
{
  //Lecture header
  fread (&OCCUR_BITS, 1, 1, input);
  
  printf ("Number bits for a occurence: %u\n\n", OCCUR_BITS);
  printf ("Uncompress in progress... 0%% achieved.");
  
  //Dcompression RLE2
  RLE2_Uncompress (input, output);
   
  return -1;
}

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
//Recherche de divers paramtres
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
int RLE2_SearchParameters (int argc, char *argv[])
{
  //Taille par dfaut
  unsigned char occur_bits=DEFAULT_OCCUR_BITS;
   
  //Parcours arguments
  for (int i=1; i<argc; i++)
  {
    //Argument WINDOW_SIZE
    if (!strncmp (StrCnvL (argv [i]), "/occur_bits=", 12)) {
      //Recherche nombre
      occur_bits=StrToInt (argv [i]+12, strlen (argv [i]+12));
      break;}
  }
  
  //Erreur argument
  if ((occur_bits==0) || (occur_bits>16)) {
    cerr << "Error: Incorrect parameter OCCUR_BITS.\n";
    return 23;}
    
  //Assignation de la taille du dictionnaire
  OCCUR_BITS=occur_bits;
  
  //Aucune erreur
  return -1;
}
