//Algorithme de compression et de dcompression LZW (Lempel Ziv Welch)
#include "fonctions.h"
#include "LZW.h"

using namespace std;

//Variables
unsigned char *DICO [DICO_SIZE];                    //Pointeur sur les chanes
unsigned char DICO_LEN [DICO_SIZE];                 //Nombres de caractres composant une chane

unsigned short DICO_POS;                            //Position dans le dictionnaire

unsigned short HACH_DICO_SIZE [256]={};
unsigned short HACH_INDEX [DICO_SIZE][256];

unsigned long LZW_input_size;  //Taille du fichier d'entr

//Initialisation du dictionnaire et de certaines variables
void LZW_Initialize (unsigned char *dico [], unsigned char dico_len [], unsigned short &dico_pos)
{
  /*//Parcours code ASCII
  for (int i=0;i<256;i++)
  {
    dico [i]=new unsigned char;
    dico [i][0]=i;
    
    dico_len [i]=1;
  }*/
    
  //Position dans le dictionnaire
  dico_pos=DICO_START;
}

//Recherche d'une occurence dans le dictionnaire
unsigned short LZW_DicoFind (unsigned char *dico [], unsigned char dico_len [], unsigned short dico_pos, unsigned short hach_size [], unsigned short hach_index [DICO_SIZE][256], unsigned char *tampon, unsigned short tampon_size)
{  
  //Parcours dictionnaire
  /*for (unsigned short i=DICO_START; i!=dico_pos; i++)
    //Si occurence de mme taille dans le dictionnaire et le tampon?
    //if ((dico_len [i]==tampon_size))// && (dico [i][tampon_size-1]==tampon [tampon_size-1]))
    //  if (((tampon_size==2) && (tampon [0]==dico [i][0])) || ((tampon_size>2) && !memcmp (tampon, dico [i], tampon_size)))
    if (!memcmp (tampon, dico [i], tampon_size))
            //Renvoie position dans le dico
        return i;
  
  return 0;*/
  
 for (unsigned short i=DICO_START; i!=dico_pos; i++)
    if (dico_len [i]==tampon_size) 
      if (!memcmp (tampon, dico [i], tampon_size)) 
        return i;
  
  return 0;
   
  /*for (unsigned short i=0; i!=hach_size [tampon [0]]; i++)
  {
    if ((dico_len [hach_index [tampon [0]][i]])==tampon_size)
      if (!memcmp (tampon, dico [hach_index [tampon [0]][i]], tampon_size))
        return i;
  }
  
  return 0;*/
}

//Ecriture dans le dictionnaire
void LZW_DicoWrite (unsigned char *dico [], unsigned char dico_len [], unsigned short &dico_pos, unsigned char *tampon, unsigned short tampon_size, unsigned short hach_size [], unsigned short hach_index [DICO_SIZE][256])
{
  //Allocation sur la pile
  dico [dico_pos]=new unsigned char [tampon_size];
  
  //Longueur de la chane
  dico_len [dico_pos]=tampon_size;
  
  //Ecriture de la chane dans le dictionnaire
  memcpy (dico [dico_pos], tampon, tampon_size);
  
  //Table de hachage
  hach_index [tampon [0]][hach_size [tampon [0]]]=dico_pos++;
  hach_size [tampon [0]]++;
}

//Vrifie dpassement dictionnaire, VIDER DICTIONNAIRE
BOOL LZW_CheckFullDico (unsigned short &dico_pos, unsigned short hach_size [], unsigned char &nbit, FILE *output, unsigned char &byte, unsigned char &start)
{
  //Si dictionnaire non plein
  if (dico_pos!=DICO_SIZE-1) return false;
  
  //Dictionnaire plein, VIDER
  dico_pos=DICO_START;        //Dictionnaire au dbut
  
  BitWrite (LZW_CLEAR, byte, start, nbit, output);  //Ecriture commande
  nbit=LZW_BITSTART;  //Codage des adresse sur n bits
  
  //printf ("Dictionnary clear.\n");

  //Vide table de hachage
  memset (hach_size, 0, sizeof (unsigned short)*256);

  //On a vid le dictionnaire
  return true;
}

//Efface le dictionnaire
void LZW_DeleteDico (unsigned char *dico [])
{
  //Parcours dictionnaire et efface
  for (int i=DICO_START; i!=DICO_SIZE ;i++)
    if (dico [i]!=NULL)
      delete dico [i];
}

//Application de l'algorithme de compression
void LZW_Compress (unsigned char *dico [], unsigned char dico_len [], unsigned short &dico_pos, unsigned short hach_size [], unsigned short hach_index [DICO_SIZE][256], FILE *input, FILE *output)
{
  //Tampon
  unsigned char tampon [MAX_STR]={};
  unsigned short tampon_size=1;
  unsigned char recur=0;
        
  //Variable criture fichier
  unsigned char byte=0;
  unsigned char start=0;
  unsigned char tmp;
  
  //Variables divers
  unsigned char nbit=LZW_BITSTART;          //nbits forme un caractre,  la rencontre de BITPLUS soit -1 on augmente
  
  //Variables recherche
  unsigned short find, find2;
  BOOL find_dico=false;
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  //Ecriture taille du fichier
  LZW_input_size=FileSize (input);
  fwrite (&LZW_input_size,4,1,output);
  
  //Caractre de dbut
  tampon [0]=fgetc (input);
  //BitWrite (tampon [0], byte, start, LZW_BITSTART, output);
  
  //Parcours fichier
  while (!feof (input))
  {       
    //Lit caractre
    tmp=fgetc (input);
    purcent=(++k*100)/LZW_input_size;
    
    //Fin du fichier
    //if (feof (input)) break;
    
    //Ajoute caractre dans tampon
    tampon [tampon_size++]=tmp;
           
    //Recherche
    find=LZW_DicoFind (dico, dico_len, dico_pos, hach_size, hach_index, tampon, tampon_size);
    
    //Recherche echoue
    if (!find)
    {
      //Ecrire dans le dictionnaire
      if (tampon_size>1) {
        LZW_DicoWrite (dico, dico_len, dico_pos, tampon, tampon_size, hach_size, hach_index);
        LZW_CheckFullDico (dico_pos, hach_size, nbit, output, byte, start);}
      
      //Fin de possibilit du dictionnaire (dfinition max dans le dico)
      if (find_dico)
      {
        //Correction de suite rcurrente
        /*if (recur>0 && recur<=2)
        {
          //Ecriture du caractre dans le fichier
          BitWrite (tampon [tampon_size-2], byte, start, nbit, output);
          //BitWrite (tampon [0], byte, start, nbit, output);
          printf ("%u\n",tampon [tampon_size-2]);
          //printf ("%u\n",tampon [0]);
          
          printf ("recurrance %u\n",recur);
          
          //Enlve caractre
          if (tampon_size>1)
            memmove (tampon, tampon+tampon_size, --tampon_size);
          //tampon [0]=tampon [tampon_size-1];
          //tampon_size=0;
            
          recur=0;
        }*/
        //Aucune suite
        //else 
        {
          //Prpare une nouvelle dfinition dans le dictionnaire
          tampon [0]=tmp;
          tampon_size=1;
          find_dico=false;
        
          //Ecriture de SP
          if (((1<<nbit)-1)<=find2) //{
            BitWrite (LZW_BITPLUS,byte,start,nbit++,output);
            //printf ("SP\n");}
          
          //Ecriture du caractre dans le fichier
          BitWrite (find2, byte, start, nbit, output);
          printf ("%u\n",find2);
        }
      }
      else 
      {
        /*if (tampon [tampon_size-1]==tampon [0]) 
          recur++;
        else
          recur=0;*/
        
        //Ecriture du caractre dans le fichier
        BitWrite (tampon [0], byte, start, nbit, output);
        printf ("%u\n",tampon [0]);
                
        //Enlve caractre
        if (tampon_size>1)
          memmove (tampon, tampon+tampon_size, --tampon_size);
      }
    }
    //Recherche russie
    else {
      find2=find;
      find_dico=true;}
    
    //Pourcentage
    if (purcent!=purcent2) {
      //printf ("\rCompress in progress... %u%%",purcent);
      purcent2=purcent;}
  }
  
  //Ecriture bits restant
  if (start!=0)
    fputc (byte, output);
}

//Compression mthode de compression LZW
int CompressLZW (FILE *input,FILE *output)
{
  unsigned long input_size,output_size;
  
  unsigned char buffer [MAX_STR];
  
  printf ("Compress in progress...");
  
  //Initialisation du dictionnaire
  LZW_Initialize (DICO, DICO_LEN, DICO_POS);
  
  //Cration du dictionnaire et compression
  LZW_Compress (DICO, DICO_LEN, DICO_POS, HACH_DICO_SIZE, HACH_INDEX, input, output);
  
  for (unsigned short i=DICO_START;i<DICO_POS;i++)
  {
    memcpy (buffer, DICO [i], DICO_LEN [i]);
    memset (buffer+DICO_LEN [i]+1, 0 ,1);
    
    printf ("%u - %u - %s\n",i,DICO_LEN [i],DICO [i],buffer);
  }
  
  //Efface le dictionnaire
  LZW_DeleteDico (DICO);
  
  //Taille des fichiers
  input_size=FileSize (input);
  output_size=FileSize (output);
  
  //Affiche rapport
  printf ("\n\nOriginal size: %u octets     Final size: %lu octets\n",input_size,output_size);
  printf ("Gain: %ld octets\n",input_size-output_size);
  printf ("Ratio: %ld%%\n",100-((output_size*100)/input_size));
  
  return -1;
}

//Cration du dictionnaire et dcompression du fichier
void LZW_Uncompress (unsigned char *dico [], unsigned char dico_len [], unsigned short &dico_pos, unsigned short hach_size [], unsigned short hach_index [DICO_SIZE][256], FILE *input, FILE *output)
{
  unsigned long counter=0;
  
  //Tampon
  unsigned char tampon [MAX_STR]={};
  unsigned short tampon_size=1;
  
  //Buffer
  unsigned char buffer [MAX_STR]={};
  unsigned short buffer_size=0;
  unsigned short buffer_pos=0;
  BOOL ReadBuffer=false;
  BOOL EndReadBuffer=false;
  
  //Variables de recherche
  unsigned short find;
  
  //Variable criture fichier
  unsigned char byte=0;
  unsigned char start=0;
  
  //Variables divers
  unsigned char nbit=LZW_BITSTART;          //nbits forme un caractre,  la rencontre de BITPLUS soit -1 on augmente
  unsigned short tmp;
  BOOL flag;
  
  fread (&LZW_input_size,4,1,input); 
  
  //Caractre de dbut
  byte=fgetc (input);
  tampon [0]=BitRead (byte,start,LZW_BITSTART,input);
  fputc (tampon [0],output);
  
  //Parcours fichier
  while (!feof (input) && (counter!=LZW_input_size))
  { 
    //Lecture d'un caractre ou index
    if (ReadBuffer==false)
      tmp=BitRead (byte,start,nbit,input);
    else
      tmp=buffer [buffer_pos++];  
    
    //Fin de lecture de l'index du dictionnaire        
    if (ReadBuffer && (buffer_pos>buffer_size))
    {
      //Caractre
      tmp=BitRead (byte, start, nbit, input);
      //printf ("%u\n",tmp);
      
      //Fin de lecture du buffer
      ReadBuffer=false;
      EndReadBuffer=true;
    }
    
    //Fin du fichier
    if (feof (input)) break;
     
    //Codage SP      
    if (((1<<nbit)-1)==tmp)
      nbit++;
    //Code ASCII
    else if (tmp<=255)
    {
      //Ajoute au tampon
      tampon [tampon_size++]=tmp;
      
      //Recherche
      find=LZW_DicoFind (dico, dico_len, dico_pos, hach_size, hach_index, tampon, tampon_size);
      
      //Echoue
      if (!find && (tampon_size>1))
      {
        //Ecriture dans le dictionnaire
        LZW_DicoWrite (dico, dico_len, dico_pos, tampon, tampon_size, hach_size, hach_index);
        
        //Ecriture du caractre dans le fichier
        if (!ReadBuffer) 
          fputc (tmp, output);
        
        if (ReadBuffer)
        {
          tampon_size=1;
          tampon [0]=tmp;
        }
        else
          //Enleve caractre
          memmove (tampon, tampon+tampon_size, --tampon_size);
      }
    }
    //Index dans le dictionnaire
    else
    { 
      //Ecriture de la dfinition
      fwrite (dico [tmp], dico_len [tmp], 1, output);
            
      //Prparation du buffer
      ReadBuffer=true;
      memcpy (buffer, dico [tmp], dico_len [tmp]);
      buffer_size=dico_len [tmp];
      buffer_pos=0;
    }
    
    //VIDER Tampon
    //------------
    if (EndReadBuffer)
    {
      EndReadBuffer=false;
            
      //Code ASCII
      if (tmp<=255)
      {
        tampon [0]=tmp;
        tampon_size=1;
      }
      //Encore une dfinition
      else if ((tmp>=DICO_START) && !ReadBuffer)
      {
        //Ecriture dans le dictionnaire
        LZW_DicoWrite (dico, dico_len, dico_pos, tampon, tampon_size, hach_size, hach_index);
        tampon_size=0;
      }
    }
  }
}

//Dcompression mthode de compression LZW
int UncompressLZW (FILE *input,FILE *output)
{
  unsigned char buffer[50]={};
  
  printf ("Uncompress in progress... \n\n");
  
  //Initialisation du dictionnaire
  LZW_Initialize (DICO, DICO_LEN, DICO_POS);
  
  //Cration du dictionnaire et dcompression du fichier
  LZW_Uncompress (DICO, DICO_LEN, DICO_POS, HACH_DICO_SIZE, HACH_INDEX, input, output);
  
  for (int i=DICO_START;i<DICO_POS;i++)
  {
    memcpy (buffer, DICO [i], DICO_LEN [i]);
    memset (buffer+DICO_LEN [i], 0, 1);
    
    printf ("%u - %s - %u\n",i,buffer,DICO_LEN [i]);
  }  
  
  //Efface le dictionnaire
  LZW_DeleteDico (DICO);
  
  return -1;
}
