//Algorithme de compression et de dcompression Arithmtique
#include "Header.h"
#include "fonctions.h"
#include "ARITH.h"

using namespace std;

#define BUFFER_SIZE 256
static unsigned char buffer [BUFFER_SIZE+2]={};
static unsigned char *current_byte;
static int output_mask=0;

static int input_bytes_left;
static int input_bits_left;
static int past_eof;

//Initialise la table des frquences
void ARI_CalculateFrequency (unsigned long *Tbl_Freq, FILE *file)
{
  unsigned char car;
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  //Parcours fichier
  while (!feof (file))
  {
    //Caractre en cours
    car=fgetc (file);
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    
    //Fin du fichier
    if (feof (file)) break;
    
    //Ajoute frquence
    Tbl_Freq [car]++;
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCreate table of frequency. %u%% achieved.", purcent);}
  }
  
  //Repositionne au dbut du fichier
  fseek (file, 0, SEEK_SET);
}

//Calcule scales
void ARI_CalculateScale (unsigned long *Tbl_Freq, unsigned char *Tbl_Scaled)
{
  int i;
  unsigned long max_count;
  int total;
  unsigned long scale;

  //Recherche de la plus grandes frquence
  max_count = 0;
  for (i=0; i<256; i++)
    if (Tbl_Freq [i]>max_count)
      max_count=Tbl_Freq [i];
  
  //Prpare Seuille      
  scale = (max_count/256);
  scale = scale + 1;

  for (i=0; i<256; i++) 
  {
    Tbl_Scaled [i]=(unsigned char)(Tbl_Freq [i]/scale);
    if ((Tbl_Scaled [i]==0) && (Tbl_Freq [i]!=0))
      Tbl_Scaled [i]=1;
  }

  total = 1;
  for (i=0; i<256; i++)
    total+=Tbl_Scaled [i];
  if (total>(32767-256))
    scale=4;
  else if (total>16383)
    scale=2;
  else
    return;
    
  for (i=0; i<256; i++)
    Tbl_Scaled [i]/=scale;
}

//Ecriture table
void ARI_WriteCounts (unsigned char *Tbl_Scaled, FILE *output)
{
  int first=0;
  int last;
  int next;
  int i;

  while ((first<255) && (Tbl_Scaled [first]==0))
    first++;

  for (; first<256; first=next) 
  {
    last=first+1;
    for (; ;) 
    {
      for (; last<256; last++)
        if (Tbl_Scaled [last]==0)
          break;
      last--;
      for (next=last+1; next<256; next++)
        if (Tbl_Scaled [next]!=0)
          break;
      if (next>255)
        break;
      if ((next-last)>3)
        break;
      last=next;
     }
     
     if (fputc(first, output)!=first)
       printf ("Error writing byte counts\n");
     if (fputc(last, output)!=last)
       printf ("Error writing byte counts\n");
      
     for (i=first; i<=last; i++) 
     {
       if (fputc(Tbl_Scaled [i], output)!=(int)Tbl_Scaled [i])
         printf ("Error writing byte counts\n");
     }
   }
   if (fputc(0, output)!=0)
     printf ("Error writing byte counts\n");
} 

//Build total
void ARI_BuildTotal (unsigned char *Tbl_Scaled, int *totals)
{
  for (int i=0; i<256; i++)
    totals [i+1]=totals [i]+Tbl_Scaled [i];
  
  totals [256+1]=totals[256]+1;
}


//Convertie un caractre en symbole
void ARI_ConvertIntToSymbole (unsigned char c, SYMBOL *s, int *totals)
{
  s->scale=totals [256+1];
  s->low_count=totals [c];
  s->high_count=totals [c+1];
}

void ARI_InitializeOutputWrite (void)
{
  current_byte = buffer;
  *current_byte = 0;
  output_mask = 0x80;
}

void ARI_OutputBit (int bit, FILE *output)
{
  if (bit)
    *current_byte|=output_mask;
  
  output_mask>>=1;
  if (output_mask==0)
  {
    output_mask=0x80;
    current_byte++;
    
    if (current_byte==(buffer+BUFFER_SIZE))
    {
      fwrite( buffer, 1, BUFFER_SIZE, output);
      current_byte=buffer;
    }
    
    *current_byte=0;
  }
}

//Encode un symbole
void ARI_EncodeSymbole (SYMBOL *s, unsigned short &low, unsigned short &high, long &underflow_bits, unsigned char &byte, unsigned char &start, FILE *output)
{
  long range;
  
  //Applique formule
  range=(long)(high-low)+1;
  high=low+(int)((range*s->high_count)/s->scale-1);
  low=low+(int)((range*s->low_count)/s->scale);
  
  //Ecriture du code
  for (;;)
  {
    if ((high&0x8000)==(low&0x8000)) 
    {
      ARI_OutputBit (high & 0x8000, output);
      while (underflow_bits>0) 
      {
       ARI_OutputBit (~high & 0x8000, output);
       underflow_bits--;
      }
    }
    else if ((low & 0x4000) && !(high & 0x4000))
    {
      underflow_bits++;
      low&=0x3fff;
      high|=0x4000;
    } 
    else
      return;
     
    low <<= 1;
    high <<= 1;
    high |= 1;
  }
}

//Compression du fichier
void ARI_CompressFile (SYMBOL *s, int *totals, unsigned short &low, unsigned short &high, long &underflow_bits, FILE *input, FILE *output)
{
  unsigned c;   //Caractre
  
  unsigned char byte=0;
  unsigned char start=0;
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  while (!feof (input))
  {
    //Caractre en cours
    c=fgetc (input);
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    //Fin du fichier
    if (feof (input)) break;
    
    ARI_ConvertIntToSymbole (c, s, totals);
    ARI_EncodeSymbole (s, low, high, underflow_bits, byte, start, output);
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  }
  
  //Fin du fichier
  ARI_ConvertIntToSymbole (256, s, totals);
  ARI_EncodeSymbole (s, low, high, underflow_bits, byte, start, output);
  
  //Ecriture finale
  ARI_OutputBit (low & 0x4000, output);
  underflow_bits++;
  while (underflow_bits-->0)
    ARI_OutputBit (~low & 0x4000, output);
  
  fwrite(buffer, 1, (size_t)(current_byte-buffer)+1, output);
    current_byte=buffer;
    
  //Output_bits (output, 0L, 16);
  
  BitWrite (0, byte, start, 16, output);
}

//Compression Arithmtique
int CompressARI (FILE *input,FILE *output)
{
  unsigned long Tbl_Freq [256]={};
  unsigned char Tbl_Scaled [256]={};
  int totals [258]={};
  
  unsigned short low=0;
  unsigned short high=0xFFFF;
  long underflow_bits=0;
  
  SYMBOL s;
   
  printf ("Create table of frequency. 0%% achieved.");
  
  ARI_InitializeOutputWrite ();
  
  ARI_CalculateFrequency (Tbl_Freq, input);
  
  ARI_CalculateScale (Tbl_Freq, Tbl_Scaled);
  ARI_WriteCounts (Tbl_Scaled, output);
  ARI_BuildTotal (Tbl_Scaled, totals);
  
  printf ("\nCompress in progress... 0%% achieved.");
  ARI_CompressFile (&s, totals, low, high, underflow_bits, input, output);
  
  return -1;
}


//****************************
//Algorithmes de dcompression
//****************************

//Lecture de la table
void ARI_ReadTable (int *totals, FILE *input)
{
  int first;
  int last;
  int i;
  int c;
  unsigned char scaled_counts [256]={};
  
  first=fgetc(input);
  last=fgetc(input);
  
  for (;;) 
  {
    for (i=first; i<=last; i++)
      scaled_counts [i]=fgetc (input);
    
    first=fgetc (input);
    if (first==0)
      break;
    last=fgetc (input);
    
    printf ("%u - %u\n", first, last);
  }
   
  ARI_BuildTotal (scaled_counts, totals);
}

short ARI_InputBit (FILE *stream)
{
  if (input_bits_left==0)
  {
    current_byte++;
    input_bytes_left--;
    input_bits_left=8;
    if (input_bytes_left==0)
    {
      input_bytes_left=fread(buffer, 1, BUFFER_SIZE, stream);
      if (input_bytes_left==0)
      {
        if (past_eof)
        {
          fprintf(stderr, "Bad input file\n");
            exit(-1);
        }
        else
        {
          past_eof=1;
          input_bytes_left=2;
        }
      }
      current_byte = buffer;
    }
  }
  input_bits_left--;
  return ((*current_byte>>input_bits_left)&1);
}

void ARI_InitializeDecoder (unsigned short &code, FILE *input)
{
  int i;
  code = 0;
  for (i=0; i<16; i++) 
  {
    code<<=1;
    code+=ARI_InputBit (input);
  }
}

int ARI_GetCurrentCount (SYMBOL *s, unsigned short low, unsigned short high, unsigned short code)
{
  long range;
  int count;

  range=(long)(high-low)+1;
  count=(int)((((long)(code-low)+1)*s->scale-1)/range);
  return (count);
}

int ARI_ConvertSymboleToInt (int *totals, int count, SYMBOL *s)
{
  int c;
  for (c=256; count<totals [c]; c--);
  
  s->high_count=totals [c+1];
  s->low_count=totals [c];
  return (c);
}

void ARI_RemoveSymbole (unsigned short &low, unsigned short &high, unsigned short &code, SYMBOL *s, FILE *file)
{
  long range;

  range=(long)(high-low)+1;
  high=low+(int)((range*s->high_count)/s->scale-1);
  low=low+(int)((range*s->low_count)/s->scale);

  for (;;) 
  {
    if ((high & 0x8000)==(low & 0x8000))
    {
    }
    
    else if ((low & 0x4000)==0x4000 && (high & 0x4000)==0) 
    {
      code ^= 0x4000;
      low &= 0x3ffff;
      high |= 0x4000;
    } 
    else
      return;
     
    low <<= 1;
    high <<= 1;
    high |= 1;
    code <<= 1;
    code += ARI_InputBit (file);
  }
}

//Application algorithme de dcompression Arithmtique
void ARI_Uncompress (SYMBOL *s, int *totals, unsigned short &low, unsigned short &high, unsigned short &code, FILE *input,FILE *output)
{
  int count;
  int c;
  
  for (;;)
  {
    s->scale=totals [256+1];
    count=ARI_GetCurrentCount (s, low, high, code);
    c=ARI_ConvertSymboleToInt (totals, count, s);
    
    if (c==256)
      break;
    
    ARI_RemoveSymbole (low, high, code, s, input);
    fputc ((char)c, output);
  }
}

void ARI_InitializeInput (void)
{
  input_bits_left = 0;
  input_bytes_left = 1;
  past_eof = 0;
}

//Dcompression Arithmtique
int UncompressARI (FILE *input,FILE *output)
{
  SYMBOL s;
  int totals [258]={};
  
  unsigned short low=0;
  unsigned short high=0xFFFF;
  unsigned short code=0;
  
  ARI_InitializeInput ();
  ARI_ReadTable (totals, input);
  ARI_InitializeDecoder (code, input); 
  
  ARI_Uncompress (&s, totals, low, high, code, input, output);      
  return -1;
}
