#ifndef HEADER_H
#define HEADER_H

//Fichier temporaire
#define TEMP_FILE   "compdata.tmp"

//Mthodes de compression
#define RLE         0
#define TPE         1
#define HUFF        2
#define LZW         3
#define LZSS        4
#define RLE2        5
#define LZH         6
#define LZ77        7
#define ARITH       8
#define AFE         9
#define HUFF2       10

//Listes des paramtres mthodes
#define method_n 11
static char *method_lst [11] = {"rle", "rle2", "tpe", "huff", "lzw", "lzss", "lzh", "lz77", "arith", "afe", "huff2"};

//Headers des diffrents formats et variables donnes en paramtres
//TPE HEADER
extern struct _TPE_FILE {
  unsigned char header[4];       //Octets descripteur
  unsigned char compress;        //Type de compression 0=RLE 1=TPE...
  unsigned char extension_size;  //Taille de l'extension
  unsigned long size;            //Taille du fichier non compress
} TPE_FILE;

//LZW HEADER
extern struct _LZW_HEADER {
  unsigned long dico_size;
} LZW_HEADER;

//LZSS HEADER /LZ77 et LZH
extern struct _LZSS_HEADER {
  unsigned long window_size;
  unsigned short buffer_size;
} LZSS_HEADER;

//RLE2 HEADER
extern struct _RLE2_HEADER {
  unsigned char occur_bits;
} RLE2_HEADER;

#endif
