#ifndef LZW_H
#define LZW_H

//Dfinitions
#define DEFAULT_DICO_SIZE   4096//8192
#define DICO_SIZE           LZW_HEADER.dico_size

#define DICO_START          259

#define LZW_BITSTART        9

//Codage
#define LZW_BITPLUS         256 //SP
#define LZW_CLEAR_DICO      257
#define LZW_EOF             258

//Taille Max d'une chane dans le dictionnaire
#define MAX_STR             4096

//Mode
#define Mode_LZW_Compress   0
#define Mode_LZW_Uncompress 1

//Exemples d'allocations norme C99
//unsigned short (*lst)[y]=malloc(x*y*sizeof(short)); 
//unsigned void *((*ptr)[y])=malloc(x*y*sizeof(void*)); 

//Prototypes LZW
int CompressLZW (FILE *input,FILE *output);
int UncompressLZW (FILE *input,FILE *output);

//Autres prototypes
//Initialise le dictionnaire...
void LZW_Initialize (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos);
//Recherche occurence dans le dictionnaire, renvoie pos en cas de succs, 0 en cas d'echec de recherche
unsigned long LZW_DicoFind (unsigned char *dico [], Tree *hach_tree [], unsigned char *tampon, unsigned short tampon_size);
//Ecriture d'une chane dans le dictionnaire
void LZW_DicoWrite (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos, Tree *hach_tree [], unsigned char *tampon, unsigned short tampon_size, unsigned char mode);
//Vrifie si le dictionnaire doit tre effac et efface dictionnaire
BOOL LZW_CheckFullDico (unsigned long &dico_pos, Tree *hach_tree [], unsigned char &nbit, unsigned char &byte, unsigned char &start, FILE *output);
//Efface le dictionnaire
void LZW_DeleteDico (unsigned char *dico [], unsigned short dico_len [], Tree *hach_tree [], unsigned char mode);

//Application de l'algorithme
void LZW_Compress (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos, Tree *hach_tree [], FILE *input, FILE *output);
int LZW_Uncompress (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos, FILE *input, FILE *output);
int LZW_SearchParameters (int argc, char *argv[]);

#endif
