#ifndef HUFFMAN_H
#define HUFFMAN_H

//#define ASCII_MAX               256
#define H_ASCII_SIZE                256

//Arbre
typedef struct H_Tree {
  H_Tree *FGauche;
  H_Tree *FDroite;
  
  H_Tree *ptr;
    
  BOOL noeud;
  unsigned short ascii_code;
  unsigned long code;
  unsigned char bits; 
};

//Table ASCII
typedef struct {
  H_Tree donnee;
  
  unsigned long freq;
  BOOL codifie;
  unsigned short ascii_code;
  unsigned long code;
  unsigned char bits;
} H_ASCII;

//Prototypes Huffman
int CompressHuffman (FILE *input,FILE *output);
int UncompressHuffman (FILE *input,FILE *output);

//-- COMPRESSION --
//*****************
//
//Efface la table ASCII
void HUFF_ClearTable (H_ASCII *ptr_table, unsigned short ASCII_MAX);
//Crer la table des frquences
void HUFF_MakeFreq (H_ASCII *Table_ASCII, unsigned short &DimAscii, FILE *input);
//Echange de donnes (Tables H_ASCII)
void HUFF_Swap(H_ASCII *a, H_ASCII *b);
//Trie la table de frquences par ordre dcroissant
void HUFF_SortTable (H_ASCII *ptr_table, unsigned short ASCII_MAX);
//Cration de l'arbre
int HUFF_MakeTree (H_ASCII *Table_ASCII, unsigned short DimAscii, H_Tree **PtrRacine);
//Efface un arbre
H_Tree *HUFF_DeleteTree (H_Tree *arbre);
//Cration du codage
void HUFF_CreateCode (H_ASCII *Table_ASCII, H_Tree *arbre);
//Inversion du code
void HUFF_InvertCode (H_ASCII *Table_ASCII, unsigned short DimAscii, unsigned short ASCII_MAX);
//Cration de la table de correspondance de caractres dans le fichier
void HUFF_CreateTableInFile (H_ASCII *ptr_table, unsigned short DimAscii, unsigned short ASCII_MAX, FILE *file, unsigned char &EndByte, unsigned char &EndStart);
//Codage des cotets source dans le fichier de destination
void HUFF_WriteDataInFile (H_ASCII *ptr_table, FILE *input, FILE *output, unsigned char EndByte, unsigned char EndStart);

//-- DECOMPRESSION --
//*******************
//
//Lecture de la table interne au fichier
void HUFF_ReadTableInFile (H_ASCII *ptr_table, unsigned short &DimAscii, FILE *file, unsigned char &EndByte, unsigned char &EndStart);
//Crer arbre de Huffman  partir de la table ASCII pour la dcompression
void HUFF_CreateUncompressTree (H_ASCII *ptr_table, unsigned short ASCII_MAX, H_Tree **PtrRacine);
//Lecture des donnes et criture dans le fichier dcompress
void HUFF_WriteUncompressData (H_ASCII *ptr_table, H_Tree *ptr_arbre, FILE *input, FILE *output,unsigned char EndByte, unsigned char EndStart);

#endif
