//Algorithme de compression et de dcompression Huffman progressif
#include "Header.h"
#include "fonctions.h"
#include "huffman.h"
#include "huffman2.h"

using namespace std;

//Initialisation de la table, remplissage code ASCII
void HUFF2_InitializeTable (H_ASCII *Table_ASCII, unsigned short ASCII_MAX)
{
  for (int i=0; i<ASCII_MAX; i++)
    Table_ASCII [i].ascii_code=i;
}

//Ajoute frquence et trie table
void HUFF2_AddFreq (H_ASCII *Table_ASCII, unsigned short &DimAscii, unsigned short ASCII_MAX, unsigned char c)
{
  //Ajoute caractre
  for (int i=0; i<ASCII_MAX; i++)
  {
    //Ajoute frquence
    if (Table_ASCII [i].ascii_code==c)
      if (!(Table_ASCII [i].freq)++) DimAscii++;
      
    //Vide table pour futur codification
    Table_ASCII [i].codifie=false;
    Table_ASCII [i].donnee.noeud=false;
  }
}

//Copie de tables
void HUFF2_CopyTable (H_ASCII *src, H_ASCII *dest, unsigned short DimAscii)
{
  for (int i=0; i<256; i++)
  {
    dest [i].codifie=false;
  }
  
  //Parcours table
  for (int i=0; i<DimAscii; i++)
  {
    dest [i].freq=src [i].freq;
    dest [i].ascii_code=src [i].ascii_code;
    
    dest [i].donnee.ascii_code=src [i].donnee.ascii_code;
  }
}

//Cherche caractre
BOOL HUFF2_FindChar (H_ASCII *Table_ASCII, unsigned char c)
{
  if (Table_ASCII [c].codifie) return true;
  return false;
}

//Suppression d'un arbre de huffman.
H_Tree *HUFF2_DeleteTree (H_Tree *arbre)
{
  /*if (arbre->noeud)
  {
    if (arbre->FGauche->noeud) arbre->FGauche=HUFF2_DeleteTree (arbre->FGauche);
    if (arbre->FDroite->noeud) arbre->FDroite=HUFF2_DeleteTree (arbre->FDroite);
    //free (arbre);
    printf ("Deleted\n");
  }
  
  return arbre;*/
  
  //Noeud
  if (arbre->FDroite->noeud==true) //arbre->FDroite->noeud==true)
  {
    arbre->FDroite->ptr=HUFF2_DeleteTree (arbre->FDroite->ptr);
    free (arbre->FDroite);
  }
  //Feuille
  else
    free (arbre->FDroite);
  
  //Noeud
  if (arbre->FGauche->noeud==true) //arbre->FGauche->noeud==true)
  {
    arbre->FGauche->ptr=HUFF2_DeleteTree (arbre->FGauche->ptr);
    free (arbre->FGauche);
  }
  //Feuille
  else
    free (arbre->FGauche);
  
  return NULL;
}


//Application de l'algorithme
int HUFF2_Compress (H_Tree **PtrRacine, H_ASCII *Table_ASCII, unsigned short &DimAscii, FILE *input, FILE *output)
{
  //Variables fichier
  unsigned char c;    //Caractre
  unsigned char byte=0;
  unsigned char start=0;
  
  //Table ASCII temporaire de sauvegarde
  H_ASCII *table_sav=(H_ASCII *)malloc (sizeof (H_ASCII)*H_ASCII_SIZE);
  
  //Parcours fichier
  while (!feof (input))
  {
    //Caractre en cours
    c=fgetc (input);
    
    //Fin du fichier
    if (feof (input)) break;
    
    //Ecriture caractre avec le code de Huffman progressif
    if (DimAscii>1)
    {
      //Ecriture code de Huffman
      //if (HUFF2_FindChar (Table_ASCII, c))
        BitWrite (Table_ASCII [c].code, byte, start, Table_ASCII [c].bits, output);
      //else
      //  BitWrite (c, byte, start, 8, output);
    }
    //Ecriture simple caractre
    else
    {
      //Simple caractre
      BitWrite (c, byte, start, 8, output);
    }
    
    //Copie table si au moins 1 caractre
    if (DimAscii)
      HUFF2_CopyTable (table_sav, Table_ASCII, DimAscii);
    
    //Ajoute frquence
    HUFF2_AddFreq (Table_ASCII, DimAscii, H_ASCII_SIZE, c);
    HUFF2_CopyTable (Table_ASCII, table_sav, DimAscii);
    
    //Si plus d'un caractre
    if (DimAscii>1)
    {                  
      //Cration de l'arbre
      HUFF_MakeTree (Table_ASCII, DimAscii, PtrRacine);
      
      //Codification
      (*PtrRacine)->code=0; (*PtrRacine)->bits=0;
      HUFF_CreateCode (Table_ASCII, *PtrRacine);
      
      //Efface ancien arbre
      //printf ("%u - %lu\n", DimAscii, *PtrRacine);
      //*PtrRacine=
      HUFF2_DeleteTree (*PtrRacine);
      free (*PtrRacine);
      *PtrRacine=NULL;
    }
  }
  
  //Octet restant
  if (start!=0)
    //Ecriture octet
    fputc (byte, output);
    
  //Libre mmoire
  //HUFF2_DeleteTree (*PtrRacine);
  free (table_sav);
}

//Compression Huffman progressif
int CompressHuffman2 (FILE *input,FILE *output)
{ 
  //Table ASCII
  H_ASCII *Table_ASCII=(H_ASCII *)malloc (sizeof (H_ASCII)*H_ASCII_SIZE);
  
  //Variables
  unsigned short DimAscii=0;
  H_Tree *Racine=NULL;
  
  //Efface la table des frquences
  HUFF_ClearTable (Table_ASCII, H_ASCII_SIZE);
  HUFF2_InitializeTable (Table_ASCII, H_ASCII_SIZE);
  
  //Compression en Huffman progressif
  HUFF2_Compress (&Racine, Table_ASCII, DimAscii, input, output);
  
  
  return -1;
}

//Dcompression Huffman progressif
int UncompressHuffman2 (FILE *input,FILE *output)
{
  return -1;
}
