/*
  Name: To89t
  Copyright: None
  Author: Ceniza
  Date: 23/09/04 19:37
  Description: Converts text files to the TI 89 text format.
*/

#include <fstream>
#include <iostream>
#include <cstring>
#include <cstdio>
#include <string>

std::string to89tFilename(char * dest, std::string src, const char * tifn)
{
  std::string path;
  std::string filename;
  std::string strDest;

  std::string::size_type iDir = src.find_last_of("\\/:");

  if (iDir != std::string::npos)
  {
    path = src.substr(0, iDir + 1);
    src = src.substr(iDir + 1);
  }

  std::string::size_type iDot = src.rfind('.');

  if (iDot != std::string::npos)
  {
    filename = src.substr(0, iDot);
  }

  strDest = path + /*tifn + '.' +*/ filename.substr(0, 8) + ".89t";
  std::strcpy(dest, strDest.c_str());
  return filename.substr(0, 8);
}


unsigned short calcChecksum(const std::string & str, const short & fsize)
{
  unsigned short cs = 0;

  for (int i = 0; i < str.length(); ++i)
  {
    cs += static_cast<unsigned char> (str[i]);
  }

  ++cs;

  cs += *reinterpret_cast<const unsigned char *> (&fsize);
  cs += *(reinterpret_cast<const unsigned char *> (&fsize) + 1);

  return cs;
}


int main(int argc, char * argv[])
{
  char temp[256];
  char varname[8];
  char tifoldername[9];

  if (argc != 2 && argc !=3)
  {
    std::cout << "\nUsage: To89t <file> [<TI foldername>]"
                 "\n  Default TI foldername: main\n";
    return 1;
  }

  if (argc == 3)
  {
    std::strncpy(tifoldername, argv[2], 8);
  }
  else
  {
    std::strncpy(tifoldername, "main", 8);
  }

  tifoldername[8] = '\0';

  std::ifstream ifile(argv[1]);

  if (!ifile)
  {
    std::cout << "\n" << argv[1] << " couldn't be opened\n";
    return 2;
  }

  std::string strDest;
  std::getline(ifile, strDest);
  strDest = '\x20' + strDest;

  while (!ifile.eof())
  {
    std::string strRead;
    strDest += "\x0d\x20";
    std::getline(ifile, strRead);
    strDest += strRead;
  }

  strDest += '\x00';
  strDest += '\xE0';

  short fsize = strDest.length() + 2;
  int filesize = 8 + 2 + 8 + 40 + 6 + 8 + 1 + 3 + 4 + 2 + 4 + 1 + 1 + 2 + strDest.length() + 2;
  short checksum = calcChecksum(strDest, fsize);

  std::string strVarname = to89tFilename(temp, argv[1], tifoldername);
  std::strncpy(varname, strVarname.c_str(), 8);
  std::ofstream ofile(temp, std::ios::out | std::ios::binary);

  if (!ofile)
  {
    std::cout << "\n" << temp << " couldn't be created\n";
    return 3;
  }

  ofile.write("**TI89**", 8);
  ofile.write("\x01\x00", 2);
  ofile.write(tifoldername, 8);
  ofile.write("Created with To89t\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0", 40);
  ofile.write("\x01\x00\x52\x00\x00\x00", 6);
  ofile.write(varname, 8);
  ofile.write("\x0B", 1);
  ofile.write("\x00\x00\x00", 3);
  ofile.write(reinterpret_cast<char *> (&filesize), 4);
  ofile.write("\xA5\x5A", 2);
  ofile.write("\x00\x00\x00\x00", 4);
  ofile.write(reinterpret_cast<char *> (&fsize) + 1, 1);
  ofile.write(reinterpret_cast<char *> (&fsize), 1);
  ofile.write("\x00\x01", 2);
  ofile.write(strDest.data(), strDest.length());
  ofile.write(reinterpret_cast<char *> (&checksum), 2);
}

