/*
Copyright (c) 2003-2004, Richard Dillingham
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include "shared.hpp"
#include "FromTxt.hpp"

int main() {
	#ifdef WINDOWS
	long hFile;
	HANDLE hFolder;
	struct _finddata_t file;
	#else
	dirent* folder;
	dirent* file;
	DIR *hFile;
	DIR *hFolder;
	#endif

	//for each folder
	
	#ifdef WINDOWS
		//For whatever reason, neither _find* nor Find* want to return any folders except for '..'
		//So we use a trick with the dir command.
		
		system("dir /ad /b > dirlist.txt");
		FILE* dirlist=fopen("dirlist.txt","rt");
		int cont=1;
		while (cont) {
			cont=ReadLine(dirlist, tempFilenameString, folderNameMaxLength);
			//tempFilenameString now holds a folder name which was written to dirlist.txt.
			if (tempFilenameString[0]!=0) {
				//printf("Checking %s.\n",tempFilenameString);
				if (strlen(tempFilenameString)<=8) {	//skip folders whose names are > 8 characters long, as those could not have been made by ToTxt, and I'd rather not truncate long folder names, for now. May change my mind later.
					//printf("Subdir %s.\n",tempFilenameString);
					chdir(tempFilenameString);
					hFile = _findfirst( "*.txt", &file );
					if( hFile == -1L ) {
						//No .txt files found in current directory. Not really an error, so we just silently do nothing in this particular directory.
					} else {
						do {
							int r=HandleTxtFile(tempFilenameString, file.name);
							if (r==-1) {	//This is means there was a fatal error and we should quit (but still clean up).
								cont=0;
								break;
							}
						} while( _findnext( hFile, &file ) == 0 );
						_findclose( hFile );
					}
					chdir("..");
				} else {
					sprintf(tempString,"The folder name '%s' is > 8 letters long. Perhaps you want to shorten it for the TI-89? I'm ignoring it for now.",tempFilenameString);
					MessageBox(NULL, tempString,"FromTxt is complaining!",MB_OK);
				}
			}
		}
		fclose(dirlist);	
	#else
		//This has been tested
		//The code in ToTxt was tested though, so that should be fine.
		hFolder=opendir(".");
		int i2=0;
		if (hFolder==NULL) {
			if (i2==0) {
				MessageBox(NULL, "No folders found in current directory.","Error!",MB_OK);
			}
		} else {
			while ( (folder=readdir(hFolder)) != NULL ) {
				char *extension=strrchr(folder->d_name,'.');
				if (extension==NULL) {	//just see if it lacks an extension for now.
					if (strlen(folder->d_name)<=8) {	//skip folders whose names are > 8 characters long, as those could not have been made by ToTxt, and I'd rather not truncate long folder names, for now. May change my mind later.
						i2++;
						sprintf(tempFilenameString,"./%s",folder->d_name);
						chdir(tempFilenameString);
						hFile=opendir(".");
						int i=0;
						if (hFile!=NULL) {
							while ( (file=readdir(hFile)) != NULL ) {
								char *extension=strrchr(file->d_name,'.');
								if (extension!=NULL) {
									//sprintf(tempFilenameString,"./%s/%s",folder->d_name,file->d_name);
									if (strcasecmp(extension,".txt")==0) {
										printf("Good extension=[%s] file=[%s]\n",extension,file->d_name);
										int r=HandleTxtFile(folder->d_name,file->d_name);
										if (r==-1) {	//This is means there was a fatal error and we should quit (but still clean up).
											closedir(hFile);	//we're breaking out of BOTH while loops, and skipping the closedir(hFile) line below as a consequence, so we do it here first
											goto breakout; //Apparently 'break 2' isn't valid, so... I'll just use goto. Heh. You know, I still have a "DON'T DO THAT!!!" reaction to goto'ing out of a block, due to TI-86 basic programming. I suppose the memory leakage if you do that is common knowledge on the internet, but I discovered it myself (instead of reading it on the internet) along with a few of other bugs which annoyed me to end (like the >64 KB of BASIC programs running at once crash, which I had to endure half a dozen times before understanding 100% what caused it. The first 3 or 4 times I didn't have a graphlink to back my stuff on. You can imagine my annoyance, but the stuff I rewrote was better every time I rewrote it, sooo... Though one bug didn't annoy me. That was the one I used to generate a black-box character (character 0). It involved doing something funky with an equation variable which made it go FUBAR and generated a black-box. Repeating the funky operation on it made it generate more normally nonaccessable characters. I think it involved a " character too, or an equation to string command, or both.... Hmm... *shrugs* I should borrow a TI-86 and download the ROM image to play with in an emu. Actually, I should see if something similar exists on the TI-89. Of course, I COULD just get a blackbox from char(0) on the 89.... *tries* Or not. It returns an empty string! Heh heh heh. *backs up everything on the TI-89 before continuing* (I crashed my TI-89 a few times too, mostly out of curiousity about the command(s) which run asm which was compiled and stuffed in strings. It went something like this. "Well, let's try running it with different values, starting at 0 and working up. Maybe we can figure out some instruction codes." I got through a couple of tries with no effect, and then got to one which had a rather spectacular effect - the calculator cleared the screen, displayed an error message in the center, and ceased functioning completely (except for displaying that error) until I removed the batteries (but not the backup battery) and tried every reset method I knew of (none worked), and then searched the Internet for OTHER reset key-combinations, found one or two, tried them, and one worked. It wiped EVERYTHING, including the contents of the archive memory. At first I thought the variable tables had all been wiped, and so I hacked an existing RAM-dumping asm program to dump archive memory instead (took a day or so to learn what I needed to do that), ran it, got the dump, looked at it, and noted that there wasn't a damn thing there from before.)
										}
										i++;
									} else {
										printf("extension=[%s] file=[%s]\n",extension,file->d_name);
									}
								}
							}
							closedir(hFile);
						}
						chdir("..");
					} else {
						sprintf(tempString,"The folder name '%s' is > 8 letters long. Perhaps you want to shorten it for the TI-89? I'm ignoring it for now.",folder->d_name);
						MessageBox(NULL, tempString,"FromTxt is complaining!",MB_OK);
					}
				}
			}
			breakout:
			closedir(hFolder);
			if (i2==0) {
				MessageBox(NULL, "No folders found in current directory.","Error!",MB_OK);
			}
		}
	#endif
	return 0;
}
