/*
Copyright (c) 2003-2004, Richard Dillingham
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include "shared.hpp"
#include "sync.hpp"

int main() {
	FILE* filelist=fopen("files.lst","rt");
	if (filelist==NULL) {
		MessageBox(NULL, "I can't find files.tmp, which is supposed to tell me what files to do what with. You shouldn't run Sync89t directly, run the update script instead.","Error",MB_OK);
		return 0;
	}
	int cont=1;
	int srcFilesDone=0;
	int txtFilesDone=0;
	while (cont) {
		cont=ReadLine(filelist, tempFilenameString, folderNameMaxLength);
		if (tempFilenameString[0]!=0) {
			char *actualFilename=tempFilenameString+1;
			char *folder=NULL;
			for (char *tmpc=actualFilename; *tmpc!=0; tmpc++) {
				if (*tmpc=='/') {
					*tmpc=0;
					folder=actualFilename;
					actualFilename=tmpc+1;
					break;
				}
			}
			if (tempFilenameString[0]=='s') {
				int r=HandleSrcFile(actualFilename);
				if (r==0) {
					printf("From89t: '%s' \n",actualFilename);
					srcFilesDone++;
				} else if (r==-1) {
					break;
				}
			} else if (tempFilenameString[0]=='t') {
				if (folder==NULL) {	//This shouldn't actually happen, but for sanity's sake, we check.
					MessageBox(NULL, "Error: Folder is NULL for a text file. (Report this please, unless you broke the python script or something.)", "Error!", MB_OK);
					fclose(filelist);
					#ifdef WINDOWS
						system("del files.lst");
					#else
						system("rm files.lst");
					#endif
					return 0;
				}
				//printf("Stepping into %s.\n",folder);
				chdir(folder);
				int r=HandleTxtFile(folder, actualFilename);
				//printf("Stepping out.\n");
				chdir("..");
				if (r==0) {
					printf("To89t: %s\n",actualFilename);
					txtFilesDone++;
				} else if (r==-1) {
					break;	//fatal error
				}
			} else {
				printf("Unknown file-type %c for file %s.",tempFilenameString[0],actualFilename);
			}
		}
	}
	fclose(filelist);
	filelist=fopen("files.lst","wb");	//empty the list file and update its timestamp.
	fclose(filelist);
	if (txtFilesDone==0 && srcFilesDone==0) {
		printf("No files have been updated, so none have been converted (in either direction).\n");
	} else {
		if (txtFilesDone!=0) {
			printf("%i .txt files had changed, and have now had their .89t files rebuilt. (You're going to send the changed .89t files to your TI-89 now, so it's up to date, right?)\n",txtFilesDone);
		}
		if (srcFilesDone!=0) {
			printf("%i .89t files had changed, and have now had their .txt files rebuilt.\n",srcFilesDone);
		}
	}
	return 0;
}
