/*
Copyright (c) 2003-2004, Richard Dillingham
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include "shared.hpp"
#include "ToTxt.hpp"

int main() {
	int cont=1;
	#ifdef WINDOWS
	struct _finddata_t file;
	long hFile;
	#else
	dirent* file;
	DIR *hFile;
	#endif


	#ifdef WINDOWS
		hFile = _findfirst( "*.89t", &file );
		if( hFile == -1L ) {
			MessageBox(NULL, "No .89t files found in current directory.","Error!",MB_OK);
		} else {
			do {
				int r=HandleSrcFile(file.name);
				if (r==-1) break;
			} while( _findnext( hFile, &file ) == 0 );
			_findclose( hFile );
		}
		hFile = _findfirst( "*.89p", &file );	//no error if these are missing
		if( hFile != -1L ) {
			do {
				int r=HandleSrcFile(file.name);
				if (r==-1) break;
			} while( _findnext( hFile, &file ) == 0 );
			_findclose( hFile );
		}
	#else
		hFile=opendir(".");
		int i=0;
		if (hFile==NULL) {
			if (i==0) {
				MessageBox(NULL, "No .89t files found in current directory.","Error!",MB_OK);
			}
		} else {
			while ( (file=readdir(hFile)) != NULL ) {
				char *extension=strrchr(file->d_name,'.');
				if (extension!=NULL) {
					if (strcasecmp(extension,".89t")==0) {
						int r=HandleSrcFile(file->d_name);
						if (r==-1) break;
						i++;
					} else if (strcasecmp(extension,".89p")==0) {
						int r=HandleSrcFile(file->d_name);
						if (r==-1) break;
						i++;
					}
				}
			}
			closedir(hFile);
			if (i==0) {
				MessageBox(NULL, "No .89t/.89p files found in current directory.","Error!",MB_OK);
			}
		}
	#endif
	return 0;
}
