/*
Copyright (c) 2003-2004, Richard Dillingham
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef SHAREDHPP
#define SHAREDHPP
#include <stdio.h>

#ifdef WINDOWS
	#include <windows.h>
	#include <io.h>
	#include <direct.h>	//For chdir
#else
	#include <sys/types.h>
	#include <dirent.h>
	#include <stdlib.h>
	#include <sys/unistd.h>	//For chdir
#endif

#include <math.h>
#include <ctype.h>
#include <string.h>

#ifndef WINDOWS
	#define MB_OK 0
	void MessageBox(char *a, char *str, char *title, int b);

#endif

#ifdef WINDOWS
	#define PATHSTR "\\"
	#define PATHCHAR '\\'
#else
	#define PATHSTR "/"
	#define PATHCHAR '/'
#endif

int ReadLine(FILE *inFile, char *string, int max);
int HandleTxtFile(char * folderName, char* fileName);
int HandleSrcFile(char* filename);

#define tempStringMaxLength 512
#define folderNameMaxLength 128

extern int mode;

extern FILE *orig;
extern FILE *final;

extern char tempString[tempStringMaxLength];
extern char tempString2[tempStringMaxLength];
extern char folderName[folderNameMaxLength];

#endif
