// Sauf mention contraire, toutes les fonctions ont t codes par Thibaut Barthlemy
// Veuillez excuser mon anglais pitoyable l o j'ai tent de nommer mes identificateurs en cette belle langue
// N'hsitez pas  m'crire : barthib@hotmail.com




// C Source File
// Created 02/11/02; 23:30:00


#ifdef __GTC__
  #include "common_files\global_declarations.h"
#else
  #include "global_declarations.h"
#endif




#define VERSION_ALGORITHME        2
#define TAILLE_BUFFER             8


#define octet2feuille(BlocNoeuds, octet)\
        ({ /* rappelons que chacun des 256 premiers noeuds de BlocNoeuds a pour index l'octet qu'il resprsente : ce sont les feuilles */\
           short offset= (unsigned short)(octet);\
           offset+= offset;       /* 2.x */\
           offset-= offset << 3;  /* 2.x - 8.2.x = -12.x */\
           (tNoeud *)((char *)(BlocNoeuds) - offset);\
        })




typedef struct sNoeud {
  struct sNoeud    *pere,
                  *fils_zero;  // NULL indique que le noeud est en fait une feuille
  union {
    struct sNoeud  *fils_un;   // pour les noeuds
    unsigned short octet;      // pour les feuilles
  };  // 4 octets
  short            bit;        // 0 ou 1 : dpend simplement du nom du pointeur du pre (fils_zero/fils_un)
} tNoeud;  // 14 octets

typedef struct sBase {
  unsigned short frequence;
  tNoeud         *noeud;
  struct sBase  *next;
} tBaseElement;  // 10 octets


tNoeud *construire_arbre(tBaseElement *base, tNoeud *arbre, short ignorer_zeros);




// --------------------------------------------------------------------------------------------------
#define ajouter_bit(destptr, bit)\
        ({\
           compresser__buffer|= (bit);\
           if (--compresser__decompte_bits <= 0)\
           {\
             *(destptr)++= compresser__buffer;\
             compresser__decompte_bits= TAILLE_BUFFER;\
           }\
           compresser__buffer+= compresser__buffer;\
        })


unsigned char  compresser__buffer;         // modifi par la macro ajouter_bit  /!\ modifier la constante TAILLE_BUFFER si changement de type
short          compresser__decompte_bits;  // modifi par la macro ajouter_bit
unsigned char *compresser__tree_svg_ptr;   // modifi par la macro ajouter_bit
unsigned char *compresser__encode;         // modifi par la macro ajouter_bit
tACFformat2   *compresser__sortie;




void atteindre_feuilles(tNoeud *noeud)  // fonction qui sauvegarde l'arbre dans tree_svg
{
  if (noeud->fils_zero != NULL)                // si on n'a pas atteind une feuille
  {
    ajouter_bit(compresser__tree_svg_ptr, 1);  // on enregistre le noeud (cod par un 1)
    atteindre_feuilles(noeud->fils_zero);      // on descend sur le fils d'indice zro
    atteindre_feuilles(noeud->fils_un);        // puis sur le fils d'indice un
  }
  else                                         // si on a atteind une feuille
  {
    ajouter_bit(compresser__tree_svg_ptr, 0);  // on signale la feuille (code par un 0)
    *compresser__encode++= noeud->octet;       // on crit l'octet que reprsente la feuille
    compresser__sortie->data.nb_leaf_m1++;     // on compte le nouvel octet
  }
}




HANDLE compresser(HANDLE fichier, tFileType virtual_type)
{
  tBaseElement base[256];   // Attention, la fonction construire_arbre dtruira tout le contenu de cette table
  tNoeud bloc_noeuds[512];  // bloc_noeuds contiendra tous les noeuds de l'arbre
  tNoeud *racine;           // racine de l'arbre
  
  unsigned short original_taille= *(unsigned short *)HeapDeref(fichier);
  HANDLE sortieHdl;  // handle du bloc qui va recevoir le fichier compress
  unsigned char *entree;
  unsigned short i;
  
  //                                            +---------- taille maximale de la liste des octets cods par l'arbre
  //                                            |  +------- taille maximale de la description de l'arbre (1 bit par noeud * 512)
  //                                            |  |  +---- taille du tag ACF
  //                                            |  |  |
  //                                            |  |  |
  if (original_taille < 2*(sizeof(tACFformat2)+256+64+6)) return H_INCHANGE;
  
  compresser__buffer= 0;
  compresser__decompte_bits= TAILLE_BUFFER;
  
  sortieHdl= HeapAlloc(original_taille + sizeof(tACFformat2) + 256 + 64 + 6);
  if (sortieHdl == H_NULL) return H_NULL;
  compresser__sortie= HeapDeref(sortieHdl);
  compresser__encode= compresser__sortie->data.compressed;
  
  { // initialisation de l'arbre, du fichier de sortie et de la base
    short j;  // sign pour le dbf quand la valeur est indirecte
    unsigned char tree_svg[512/8];  // buffer qui contient la description de l'arbre
    tBaseElement *pbase= base;
    
    
    compresser__tree_svg_ptr= tree_svg;
    
    j= 256; while (j--) (pbase++)->frequence= 0;  // initialisation des frquences de la base
    compresser__sortie->header.format_version= VERSION_ALGORITHME;
    compresser__sortie->header.original_virtualtype= virtual_type;
    compresser__sortie->header.original_datasize= original_taille;
    compresser__sortie->data.nb_leaf_m1= -1;  // incrment par la fonction atteindre_feuille
    
    entree= HeapDeref(fichier) + 2;  // on saute le mot qui donne la taille du segment de donnes du fichier d'origine
    i= original_taille;
    while (i--) base[*entree++].frequence++;  // comptage des occurences de chaque octet du fichier
    
    racine= construire_arbre(base, bloc_noeuds, TRUE);  // construction de l'arbre
    
    atteindre_feuilles(racine);  // sauvegarde de l'arbre
    j= compresser__tree_svg_ptr - tree_svg;  // nombre d'octets contenant la sauvegarde, arrondit  l'octet infrieur (on peut avoir 5 octets et 3 bits, par exemple)
    compresser__tree_svg_ptr= tree_svg;
    while (j--) *compresser__encode++= *compresser__tree_svg_ptr++;  // copie de la sauvegarde, octet par octet
    // s'il reste des bits aprs ces octets, ils seront crits pendant la compression,  la premire compltion du buffer
  }
  
  entree= HeapDeref(fichier) + 2;
  i= original_taille;
  while (i--)
  {
    tNoeud *noeud= octet2feuille(bloc_noeuds, *entree++);  // obtention de l'adresse de la feuille correspondant  l'octet
    unsigned char reversed[256], *preversed= reversed;
    short j;
    
    while (noeud->pere != NULL)  // on remonte jusqu' la racine de l'arbre (la racine n'a pas de pre)
    {
      *preversed++= noeud->bit;  // stockage des bits menant jusqu' la racine
      noeud= noeud->pere;         // on remonte dans l'arbre
    }
    j= preversed - reversed;
    while (j--) ajouter_bit(compresser__encode, *--preversed);  // criture des bits,  l'envers
  }
  while (compresser__decompte_bits != TAILLE_BUFFER) ajouter_bit(compresser__encode, 0);  // on complte le dernier mot avec des zros puis on l'crit
  
  { // mise en place de l'extension et criture de la taille du fichier
    char *fin= compresser__encode;
    *fin++= 0;
    *fin++= 'a';
    *fin++= 'c';
    *fin++= 'f';
    *fin++= 0;
    *fin++= OTH_TAG;
    compresser__sortie->header.datasize= fin - (char *)&compresser__sortie->header.datasize - 2;
  }
  
  if (original_taille+2 < compresser__sortie->header.datasize)
  {
    HeapFree(sortieHdl);
    return H_INCHANGE;
  }
  HeapRealloc(sortieHdl, compresser__sortie->header.datasize + 2);
  return sortieHdl;
}
// --------------------------------------------------------------------------------------------------




#define lire_bit()\
        ({\
           decompresser__buffer+= decompresser__buffer;\
           if (--decompresser__decompte_bits <= 0)\
           {\
             decompresser__buffer= *decompresser__compressed++;\
             decompresser__decompte_bits= TAILLE_BUFFER;\
           }\
           decompresser__buffer & (1 << (TAILLE_BUFFER-1));\
        })


unsigned char  decompresser__buffer;         // modifi par la macro lire_bit  /!\ modifier la constante TAILLE_BUFFER si changement de type
short          decompresser__decompte_bits;  // modifi par la macro lire_bit
unsigned char *decompresser__compressed;     // modifi par la macro lire_bit
tNoeud        *decompresser__prochain_noeud;
unsigned char *decompresser__octets;
tNoeud        *decompresser__bloc_noeuds;    // bloc_noeuds contiendra tous les noeuds de l'arbre




tNoeud *reconstruire_arbre(tNoeud *pere, short bit)
{
  tNoeud *adresse;
  
  if (lire_bit() != 0)  // noeud
  {
    adresse= decompresser__prochain_noeud++;
    adresse->pere= pere;
    adresse->fils_zero= reconstruire_arbre(adresse, 0);
    adresse->fils_un= reconstruire_arbre(adresse, 1);
    adresse->bit= bit;
  }
  else                  // feuille
  {
    unsigned short octet= *decompresser__octets++;
    
    adresse= octet2feuille(decompresser__bloc_noeuds, octet);
    adresse->pere= pere;
    adresse->fils_zero= NULL;
    adresse->octet= octet;
    adresse->bit= bit;
  }
  
  return adresse;
}




HANDLE decompresser(HANDLE fichier)
{
  tNoeud bloc_noeuds[512];  // bloc_noeuds contiendra tous les neouds de l'arbre
  tNoeud *racine= NULL;     // racine de l'arbre
  
  tACFheader *header= HeapDeref(fichier);
  short version= header->format_version;
  unsigned short original_taille= header->original_datasize;
  HANDLE sortieHdl= HeapAlloc(original_taille + 2);  // handle du bloc qui va recevoir le fichier dcompress
  unsigned char *sortie= HeapDeref(sortieHdl);
  unsigned short i;
  
  
  if (sortieHdl == H_NULL) return H_NULL;
  
  decompresser__buffer= 0;
  decompresser__decompte_bits= 0;
  decompresser__bloc_noeuds= bloc_noeuds;
  
  switch (version)  // initialisation de l'arbre
  {
    case 1 : {
               tBaseElement base[256];  // Attention, la fonction construire_arbre dtruira tout le contenu de cette table
               tACFformat1 *entree= HeapDeref(fichier);
               unsigned short *poccurences= entree->data.occurences;
               tBaseElement *pbase= base;
               
               
               decompresser__compressed= entree->data.compressed;
               i= 256;
               while (i--) (pbase++)->frequence= *poccurences++;     // copie des frquences dans la base
               racine= construire_arbre(base, bloc_noeuds, FALSE);  // construction de l'arbre. La version 1 de l'algo tait bogue : elle intgrait  l'arbre les octets de frquence 0 => on passe FALSE en dernier argument
             }
             break;
    case 2 : {
               tACFformat2 *entree= HeapDeref(fichier);
               
               
               decompresser__octets= entree->data.compressed;
               decompresser__prochain_noeud= &bloc_noeuds[256];  // les 256 premiers noeuds sont rservs aux feuilles
               decompresser__compressed= entree->data.compressed + entree->data.nb_leaf_m1 + 1;  // les bits sont aprs la liste des octets cods par l'arbre
               racine= reconstruire_arbre(NULL, 0);  // reconstruction de l'arbre
             }
             break;
  }
  
  // initialisation du fichier de sortie
  *((unsigned short *)sortie)++= original_taille;  // criture de la taille du segment de donnes du fichier d'origine
  
  i= original_taille;
  while (i--)
  {
    tNoeud *noeud;
    
    noeud= racine;
    while (noeud->fils_zero != NULL)  // on descend jusqu' la feuille
    {
      if (lire_bit() == 0) noeud= noeud->fils_zero;
                      else noeud= noeud->fils_un;
    }
    *sortie++= noeud->octet;
  }
  
  return sortieHdl;
}
// --------------------------------------------------------------------------------------------------




tNoeud *construire_arbre(tBaseElement *base, tNoeud *arbre, short ignorer_zeros)
{
  short taille_base_m1= -1;  // pour pouvoir tester par rapport  zro dans la condition de la boucle o on construit l'arbre, on soustrait 1
  tNoeud *prochain_noeud;
  tBaseElement *pbase,
               *next;
  short i;
  
  next= NULL;  // le dernier lment "utile" de la base n'aura pas de frre, puisque c'est le dernier
  pbase= &base[256];
  prochain_noeud= &arbre[256];
  i= 256;
  if (ignorer_zeros)
  {
    while (i--)  // mise en correspondance de la table d'occurences et des feuilles (256 premiers noeuds)
    {
      prochain_noeud--;  // chaque feuille de l'arbre a pour index l'octet qu'elle reprsente
      if ((--pbase)->frequence != 0)  // si l'octet ni apparat dans le fichier
      {
        pbase->next= next;
        pbase->noeud= prochain_noeud;
        prochain_noeud->fils_zero= NULL;  // par dfinition mme, les feuilles n'auront jamais de fils
        prochain_noeud->octet= i;         // octet associ  la feuille :)
        next= pbase;
        taille_base_m1++;
      }
    }
  }
  else  // il faut quand mme intgrer  l'arbre les octets qui n'apparaissent jamais
  {
    while (i--)  // mise en correspondance de la table d'occurences et des feuilles (256 premiers noeuds)
    {
      prochain_noeud--;  // chaque feuille de l'arbre a pour index l'octet qu'elle reprsente
      pbase--;
      pbase->next= next;
      pbase->noeud= prochain_noeud;
      prochain_noeud->fils_zero= NULL;  // par dfinition mme, les feuilles n'auront jamais de fils
      prochain_noeud->octet= i;         // octet associ  la feuille :)
      next= pbase;
      taille_base_m1++;
    }
  }
  base= next;  // base pointe sur le premier lment "utile"
  prochain_noeud+= 256;
  
  while (taille_base_m1--)  // construction de l'arbre, on s'arrte lorsqu'il ne reste plus qu'un lment "en l'air" : c'est la racine
  {
    tBaseElement *b0, *b1;  // pointeurs sur les deux racines de l'arbre qui ont la plus faible occurence
    tNoeud *b0_noeud, *b1_noeud;
    
    // prparation  la recherche des 2 plus faibles occurences
    if (base->frequence < base->next->frequence)
    {
      b0= base;
      b1= base->next;
    }
    else
    {
      b0= base->next;
      b1= base;
    }
    pbase= base->next->next;
    while (pbase != NULL)
    {
      if (pbase->frequence < b0->frequence)  // si on trouve une occurence plus faible que celle indique par b0
      {
        b1= b0;     // alors la seconde plus faible ocurrence devient l'ancienne premire
        b0= pbase;  // et la plus faible des deux devient celle qu'on a trouv
      }
      else
        if (pbase->frequence < b1->frequence)  // sinon, si on trouve plus faible que b1
        {
          b1= pbase;
        }
      pbase= pbase->next;  // on passe au pointeur du noeud suivant
    }
    if (b0->next == NULL)  // si b0 est le dernier lment de la base (pas de frre)
    {                      // on change les pointeurs pour que b0 ait un frre
      void *tmp= b0;
      b0= b1;
      b1= tmp;
    }
    b0_noeud= b0->noeud;
    b1_noeud= b1->noeud;
    //  cause du code ci-dessous, il n'existe plus de lien entre chaque lment de la base et l'octet qu'il reprsente
    // mise  jour des deux racines pour qu'elles deviennent des noeuds
    b0_noeud->pere= prochain_noeud;  // le premier noeud va avoir un pre
    b0_noeud->bit= 0;                // qu'on lie par une branche, d'indice 0 pour ce fils
    b1_noeud->pere= prochain_noeud;  // le second noeud va avoir le mme pre
    b1_noeud->bit= 1;                // qu'on lie par l'autre branche, d'indice 1
    // cration de leur pre
    prochain_noeud->fils_zero= b0_noeud;
    prochain_noeud->fils_un= b1_noeud;
    // inutile d'initialiser le champ bit et le champ pere
    // la base b1 est crase pour rfrencer le pre
    b1->noeud= prochain_noeud;      // on ne s'occupe plus des deux fils. On fait pointer le second lment de la base vers le nouveau noeud liant les deux prcdents
    b1->frequence+= b0->frequence;  // ce pre a pour frquence la somme des frquences de ses fils :)
    prochain_noeud++;               // mise  jour de l'adresse du prochain nouveau noeud
    // suppression de la base b0
    b0->frequence= b0->next->frequence;  // transformation ! les frres deviennent jumeaux
    b0->noeud= b0->next->noeud;          // ...
    b0->next= b0->next->next;            // le frre sort de la liste chaine. Son clone est toujours l
  }
  prochain_noeud--;
  prochain_noeud->pere= NULL;
  
  return prochain_noeud;
}



